package com.zzsn.leaderbase.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.*;

import java.util.Date;

/**
 * <p>
 *5.1 人物变更信息咨询抽取表
 * </p>
 *
 * @since
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("character_change_info_extract")
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CharacterChangeInfoExtract extends Model<CharacterChangeInfoExtract>
 {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 关联人物id
     */
    @TableField("uid")
    private String uid;

    /**
     *人物名称
     */
    @TableField("name")
    private String name;

    /**
     *原部门 原单位 原企业
     */
    @TableField("department_original")
    private String departmentOriginal;

    /**
     *原职务
     */
    @TableField("duty_original")
    private String dutyOriginal;

    /**
     *部门 单位 企业(现)
     */
    @TableField("department")
    private String department;

    /**
     *职务(现)
     */
    @TableField("duty")
    private String duty;

    /**
     *任职时间
     */
    @TableField("take_office_status")
    private String takeOfficeStatus;

    /**
     *任职状态
     */
    @TableField("take_office_time")
    private Date takeOfficeTime;

    /**
     *变更链接
     */
    @TableField("change_url")
    private String changeUrl;

    /**
     *职务变更时间
     */
    @TableField("duties_update_time")
    private Date dutiesUpdateTime;

    /**
     *职务变更原因
     */
    @TableField("duties_update_reason")
    private String dutiesUpdateReason;



    /**
     *是否审核  1是 0否
     */
    @TableField("check_status")
    private Integer checkStatus;

    /**
     *是否审核通过 0未通过 1通过 2待定
     */
    @TableField("check")
    private Integer check;

    /**
     *关联资讯id
     */
    @TableField("article_id")
    private String articleId;

    /**
     *关联资讯标题
     */
    @TableField("article_title")
    private String articleTitle;

    /**
     *变更描述
     */
    @TableField("update_desc")
    private String updateDesc;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private Date createTime;

}
