package com.zzsn.leaderbase.util;


import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

import java.text.NumberFormat;
import java.util.ArrayList;

public class ExcelUtil {
    public static ArrayList<ArrayList<String>> analysis(Sheet sheet) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        ArrayList<ArrayList<String>> row = new ArrayList<>();
        for (int i = 0; i < sheet.getPhysicalNumberOfRows(); i++) {
            // 循环获取工作表的每一行
            Row sheetRow = sheet.getRow(i);
            if(sheetRow == null){
                continue;
            }
            // 循环获取每一列
            ArrayList<String> cell = new ArrayList<>();
            for (int j = 0; j < sheetRow.getLastCellNum(); j++) { //
                // 将每一个单元格的值装入列集合
                if (sheetRow.getCell(j) != null) {
                    try {
                        cell.add(sheetRow.getCell(j).getStringCellValue().trim());
                    }catch (Exception e){
                        cell.add(String.valueOf(sheetRow.getCell(j).getNumericCellValue()));
                    }
                } else {
                    cell.add("");
                }
            }
            // 将装有每一列的集合装入大集合
            row.add(cell);
        }
        return row;
    }
    public static boolean judegExcelEdition(String fileName) {
        String regex = "^.+\\.(?i)(xls)$";
        return !fileName.matches(regex);
    }
}
