package com.zzsn.leaderbase.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @author lkg
 * @description: 企业高管表
 * @date 2023/1/9
 */
@Data
public class ExecutiveNew implements Serializable {

    /**
     * 人员序号
     */
    private Integer serialNumber;
    /**
     * 人员姓名
     */
    private String name;
    /**
     * 人员关联的统一社会信用代码
     */
    private String socialCreditCode;
    /**
     * 人员关联的企业名称 公司名称
     */
    private String companyName;
    /**
     * 性别
     */
    private String gender;
    /**
     * 年龄
     */
    private String age;
    /**
     * 学历
     */
    private String education;
    /**
     * 是否法人
     */
    private String corporationFlag;
    /**
     * 职位
     */
    private String position;
    /**
     * 任职日期
     */
    private String employmentDate;
    /**
     * 薪酬（元）
     */
    private String salary;
    /**
     * 持股比例（%）
     */
    private String shareholdingPercentage;
    /**
     * 持股数(股)
     */
    private String shareholdingNum;
    /**
     * 报告日期
     */
    private String reportDate;
    /**
     * 个人id
     */
    private String personnelId;
    /**
     * 公司id
     */
    private String companyId;
    /**
     * 公司相关id
     */
    private String companyRelatedId;
    /**
     * 个人简介
     */
    private String briefInfo;
    /**
     * 最新采集标识：0-最新；1-历史
     */
    private Integer stateFlag;
    /**
     * 数据集采集时间
     */
    private String createTime;

}
