package com.zzsn.leaderbase.controller;

import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.entity.CharacterExtractInfo;
import com.zzsn.leaderbase.service.CharacterBasicInfoService;
import com.zzsn.leaderbase.service.CharacterExtractInfoService;
import com.zzsn.leaderbase.util.SortUtil;
import com.zzsn.leaderbase.vo.CheckVo;
import com.zzsn.leaderbase.vo.ExtractListVo;
import com.zzsn.leaderbase.vo.Result;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 审核
 */
@RestController
@RequestMapping("/api/extract")
@Slf4j
public class CharacterExtractInfoController {

    @Autowired
    CharacterExtractInfoService characterExtractInfoService;
    @Autowired
    CharacterBasicInfoService characterBasicInfoService;;


    /**
     * 资讯抽取人物信息分页查询
     * 人物审核列表
     * @param
     * @return
     */
    @PostMapping("/list")
    public Result<?> getList(@RequestBody ExtractListVo extractListVo){
        log.info("人物审核列表:{}", extractListVo);
        Integer office = extractListVo.getPageSize() * (extractListVo.getPageNo() - 1);
        extractListVo.setOffset(office);
        extractListVo.setColumn(SortUtil.humpToLine(extractListVo.getColumn()));
        return characterExtractInfoService.getList(extractListVo);
    }

    /**
     * 根据人物id主键删除
     * @param id
     * @return
     */
    @GetMapping("/del")
    public Result<?> del(@RequestParam(name="id",required=true) String id){
        log.info("人物审核根据人物id删除:{}", id);
        return characterExtractInfoService.del(id);
    }

    /**
     * 根据id 查询
     * @param id
     * @return
     */
    @GetMapping("/getById")
    public Result<?> getById(@RequestParam(name="id",required=true) String id){
        log.info("人物审核根据人物id查询:{}", id);
        CharacterExtractInfo info = characterExtractInfoService.getById(id);
        return Result.OK(info);
    }


    /**
     * 新增 + 审核
     * @param checkVo
     * @return
     */
    @PostMapping("/checkNewlyAdded")
    public Result<?> checkNewlyAdded(@RequestBody CheckVo checkVo){
        log.info("新增 + 审核 {}",checkVo);
        //参数校验
        if(StringUtils.isEmpty(checkVo.getExtractId())){
            return Result.error("extractId 不能为空！");
        }
        Result<?> result = characterExtractInfoService.checkNewlyAdded(checkVo);
        if(result.isSuccess()){
            characterBasicInfoService.syncToCaoji((CharacterBasicInfo) result.getResult());
        }
        return result;
    }

    /**
     * 合并 + 审核
     * @param checkVo
     * @return
     */
    @PostMapping("/checkMerge")
    public Result<?> checkMerge(@RequestBody CheckVo checkVo){
        log.info("合并 + 审核 {}",checkVo);
        //参数校验
        if(StringUtils.isEmpty(checkVo.getExtractId())){
            return Result.error("extractId 不能为空！");
        }
        if(StringUtils.isEmpty(checkVo.getSuspectedId())){
            return Result.error("suspectedId 不能为空！");
        }
        Result<?> result = characterExtractInfoService.checkMerge(checkVo);
        if(result.isSuccess()){
            characterBasicInfoService.syncToCaoji((CharacterBasicInfo) result.getResult());
        }
        return result;
    }


}
