package com.zzsn.leaderbase.controller;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson2.JSON;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.entity.Executive;
import com.zzsn.leaderbase.entity.ExecutiveNew;
import com.zzsn.leaderbase.service.CharacterBasicInfoService;
import com.zzsn.leaderbase.service.IGeneratorIdService;
import com.zzsn.leaderbase.util.BeanUtils;
import com.zzsn.leaderbase.vo.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

/**
 * 企业相关数据同步接口
 */
@Slf4j
@RestController
@RequestMapping("/sync")
public class SyncEnterpriseDataController {


//    @Autowired
//    private ExecutiveService executiveService;

//    @Autowired
//    private EnterpriseShareholderService enterpriseShareholderService;

    @Autowired
    CharacterBasicInfoService characterBasicInfoService;
    //生成id
    @Autowired
    IGeneratorIdService generatorIdService;


    /**
     * 同步企业股东信息
     *
     * @param jsonString json字符串
     */
    /*
    @PostMapping("/shareHolder")
    public Result<?> syncShareHolder(@RequestBody String jsonString) {
        CompletableFuture.runAsync(() -> {
            List<EnterpriseShareHolder> list = JSON.parseArray(jsonString, EnterpriseShareHolder.class);
            Date date = new Date();
            List<EnterpriseShareHolder> addList = new ArrayList<>();
            for (EnterpriseShareHolder enterpriseShareHolder : list) {
                String socialCreditCode = enterpriseShareHolder.getSocialCreditCode();
                LambdaQueryWrapper<EnterpriseShareHolder> queryWrapper = Wrappers.lambdaQuery();
                queryWrapper.eq(EnterpriseShareHolder::getSocialCreditCode, socialCreditCode)
                        .eq(EnterpriseShareHolder::getName, enterpriseShareHolder.getName());
                Integer year = enterpriseShareHolder.getYear();
                if (year != null) {
                    queryWrapper.eq(EnterpriseShareHolder::getYear, year);
                }
                int count = enterpriseShareholderService.count(queryWrapper);
                if (count == 0) {
                    enterpriseShareHolder.setCreateTime(date);
                    addList.add(enterpriseShareHolder);
                }
            }
            enterpriseShareholderService.saveBatch(addList);
        });
        return Result.OK();
    }
     */

    /**
     * 同步企业核心人员数据信息
     * @param jsonString json字符串
     */
    @PostMapping("/executive")
    public Result<?> synExecutive(@RequestBody String jsonString) {
        log.info(jsonString);
        CompletableFuture.runAsync(() -> {
            //zui新采集数据
            List<Executive> listExecutive = JSON.parseArray(jsonString, Executive.class);
            log.info("list:{}", listExecutive.size());
            Map<String, Executive> mapExecutive = listExecutive.stream()
                    .collect(Collectors.toMap(Executive::getName, e -> e));

            //社会信用代码和公司名称
            String socialCreditCode = listExecutive.get(0).getSocialCreditCode();
            log.info("社会信用代码：{}",socialCreditCode);
            String department = characterBasicInfoService.getDepartmentCreditCode(socialCreditCode);//查询公司名称

            //库中已有数据
            List<CharacterBasicInfo> creditList = characterBasicInfoService.getBasicInfoByCreditCode(socialCreditCode);//查询已入库数据
            Map<String, CharacterBasicInfo> mapCredit = creditList.stream()
                    .collect(Collectors.toMap(CharacterBasicInfo::getName, e -> e));

            //处理库中已有数据
            Set<String> creditLSet = mapCredit.keySet();
            for (String name : creditLSet) {
                Executive executive = mapExecutive.get(name);
                if(executive == null){//最新数据中无此人，改为历任
                    CharacterBasicInfo basicInfo = mapCredit.get(name);
                    basicInfo.setTakeOfficeStatus("历任");
                    characterBasicInfoService.updateById(basicInfo);
                }
            }

            //处理新采集数据
            Set<String> executiveSet = mapExecutive.keySet();
            for (String name : executiveSet) {
                CharacterBasicInfo basicInfo = mapCredit.get(name);
                Executive executive = mapExecutive.get(name);
                if(basicInfo == null){//新增人员
                    CharacterBasicInfo newInfo = convert(executive);
                    newInfo.setDepartment(department);
                    newInfo.setUid(generatorIdService.getIdNo());
                    newInfo.setCategory("3");
                    newInfo.setMainEntry(1);
                    newInfo.setStatus(1L);
                    characterBasicInfoService.save(newInfo);
                } else {//已有人员
                    //判断职务是否变动//职务变动则追加职务变更记录，职务未变动则不做处理
                    String duty = basicInfo.getDuty() == null ? "" : basicInfo.getDuty();
                    if(!duty.equals(executive.getPosition())){
                        basicInfo.setTakeOfficeStatus("历任");
                        basicInfo.setMainEntry(0);
                        characterBasicInfoService.updateById(basicInfo);
                        CharacterBasicInfo newInfo = convert(executive);
                        newInfo.setDepartment(department);
                        newInfo.setUid(generatorIdService.getIdNo());
                        newInfo.setCategory("3");
                        newInfo.setMainEntry(1);
                        newInfo.setStatus(1L);
                        characterBasicInfoService.save(newInfo);
                    }
                }
            }
        });
        return Result.OK();
    }
    /**
     * 同步企业核心人员数据信息
     * @param jsonString json字符串
     */
    @PostMapping("/executiveNew")
    public Result<?> executiveNew(@RequestBody String jsonString) {
        log.info(jsonString);
        CompletableFuture.runAsync(() -> {
            //最新采集数据，以企业为单位传参
            List<ExecutiveNew> listExecutive = JSON.parseArray(jsonString, ExecutiveNew.class);
            Map<String, ExecutiveNew> mapExecutive = listExecutive.stream()
                    .collect(Collectors.toMap(ExecutiveNew::getName, e -> e));

            //社会信用代码和公司名称
            String socialCreditCode = listExecutive.get(0).getSocialCreditCode();
            log.info("社会信用代码：{}，企业高管数量：{}",socialCreditCode,listExecutive.size());

            LambdaQueryWrapper<CharacterBasicInfo> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(CharacterBasicInfo::getCategory, "3");
            queryWrapper.eq(CharacterBasicInfo::getTakeOfficeStatus, "在职");
            queryWrapper.eq(CharacterBasicInfo::getSocialCreditCode, socialCreditCode);
            List<CharacterBasicInfo> creditList = characterBasicInfoService.list(queryWrapper);

            //库中已有数据
            Map<String, CharacterBasicInfo> mapCredit = creditList.stream()
                    .collect(Collectors.toMap(CharacterBasicInfo::getName, e -> e));

            //处理库中已有数据
            Set<String> creditLSet = mapCredit.keySet();
            for (String name : creditLSet) {
                ExecutiveNew executive = mapExecutive.get(name);
                if(executive == null){//最新数据中无此人，改为历任
                    CharacterBasicInfo basicInfo = mapCredit.get(name);
                    basicInfo.setTakeOfficeStatus("历任");
                    characterBasicInfoService.updateById(basicInfo);
                }
            }

            //处理新采集数据
            Set<String> executiveSet = mapExecutive.keySet();
            for (String name : executiveSet) {
                CharacterBasicInfo basicInfo = mapCredit.get(name);
                ExecutiveNew executive = mapExecutive.get(name);
                if(basicInfo == null){//新增人员
                    CharacterBasicInfo newInfo = convertNew(executive);
                    //新增数据生成新的UID
                    newInfo.setUid(generatorIdService.getIdNo());
                    characterBasicInfoService.save(newInfo);
                } else {//已有人员
                    //判断职务是否变动//职务变动则追加职务变更记录，职务未变动更新数据
                    String duty = basicInfo.getDuty() == null ? "" : basicInfo.getDuty();
                    String position = executive.getPosition() == null ? "" : executive.getPosition();
                    if(!duty.equals(position)){
                        //更新历史数据为历任
                        basicInfo.setTakeOfficeStatus("历任");
                        basicInfo.setMainEntry(0);
                        characterBasicInfoService.updateById(basicInfo);

                        //新增新数据
                        CharacterBasicInfo newInfo = convertNew(executive);
                        //UID保持不变
                        newInfo.setUid(basicInfo.getUid());
                        characterBasicInfoService.save(newInfo);
                    }else{
                        //更新数据
                        CharacterBasicInfo merge = BeanUtils.merge(basicInfo, convertNew(executive));
                        characterBasicInfoService.updateById(merge);
                    }
                }
            }
        });
        return Result.OK();
    }

    private CharacterBasicInfo convert(Executive executive){
        CharacterBasicInfo basicInfo = new CharacterBasicInfo();
        basicInfo.setSocialCreditCode(executive.getSocialCreditCode());
        basicInfo.setName(executive.getName());
        basicInfo.setSex(executive.getSex());
        basicInfo.setEducation(executive.getEducation());
        basicInfo.setDuty(executive.getPosition());
        basicInfo.setBirthday(executive.getBirthYear() + "");
        basicInfo.setTakeOfficeTime(executive.getCurrentTerm());
        basicInfo.setBiographicalNotes(executive.getPersonInfo());
        basicInfo.setSort(executive.getSort());
        basicInfo.setCreateTime(new Date());

//        private String id;
//        /**持股数*/
//        private String shareNum;
//        /**持股比例*/
//        private String shareRatio;
//        /**最终受益股份*/
//        private String benefitShare;

        return basicInfo;
    }
    private CharacterBasicInfo convertNew(ExecutiveNew executive){
        CharacterBasicInfo basicInfo = new CharacterBasicInfo();
        basicInfo.setName(executive.getName());
        basicInfo.setSocialCreditCode(executive.getSocialCreditCode());
        basicInfo.setDepartment(executive.getCompanyName());
        basicInfo.setDuty(executive.getPosition());
        basicInfo.setSex(executive.getGender());
        basicInfo.setEducation(executive.getEducation());
        basicInfo.setTakeOfficeTime(executive.getEmploymentDate());
        basicInfo.setBiographicalNotes(executive.getBriefInfo());

        basicInfo.setCategory("3");
        basicInfo.setTakeOfficeStatus("在职");
        basicInfo.setMainEntry(1);
        basicInfo.setStatus(1L);
        return basicInfo;
    }

    @GetMapping("/get")
    public Result<?> get(){
        String socialCreditCode = "91110000400882778L";
        String department = characterBasicInfoService.getDepartmentCreditCode(socialCreditCode);
        return Result.OK();
    }
}
