package com.zzsn.leaderbase.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.leaderbase.entity.CharacterTagTop;
import com.zzsn.leaderbase.entity.LabelEntity;
import com.zzsn.leaderbase.entity.SysBaseLabelType;
import com.zzsn.leaderbase.mapper.CharacterTagMapper;
import com.zzsn.leaderbase.mapper.CharacterTagTopMapper;
import com.zzsn.leaderbase.service.CharacterTagService;
import com.zzsn.leaderbase.vo.CharacterVo;
import com.zzsn.leaderbase.vo.Result;
import com.zzsn.leaderbase.vo.SysBaseLabelTypeVo;
import com.zzsn.leaderbase.vo.SysLabelVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/21 11:04
 * @Content:
 */
@Service
public class CharacterTagServiceImpl extends ServiceImpl<CharacterTagMapper, LabelEntity> implements CharacterTagService {

    @Autowired
    CharacterTagMapper characterTagMapper;

    @Autowired
    CharacterTagTopMapper characterTagTopMapper;

    @Value("${sys_base_label_type_id}")
    private String sys_base_label_type_id;


    @Override
    public Result<?> getTagList(String id, String name) {
        if(id == null || id.length() == 0){
            id = sys_base_label_type_id;
        }
        List<SysBaseLabelType> endNodes = getEndNodes(id);
        List<String> ids = new ArrayList<>();
        if (CollectionUtil.isEmpty(endNodes)){
            ids.add(id);
        }else {
            endNodes.forEach(e->ids.add(e.getId()));
        }

//        List<SysLabelVo> pageList = null;
//        pageList = baseMapper.queryCustomLabel(sysLabelVo, offset, pageSize);
        List<SysLabelVo> pageList = characterTagMapper.queryCustomLabel(ids,name);

        return Result.OK(pageList);
    }


    @Override
    public Result<?> getCharacterListByTag(String tagName, Integer pageNo, Integer pageSize) {
        Integer offset = (pageNo -1) * pageSize;

        List<LabelEntity> tagList = null;
        //根据标签名称查询标签信息
        LambdaQueryWrapper<LabelEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(LabelEntity::getName, tagName);
        tagList = characterTagMapper.selectList(lambdaQuery);
        if(tagList.size() == 0){
            //根据名称如果没有匹配到标签信息，则使用模糊查找
            LambdaQueryWrapper<LabelEntity> lambdaQueryLike = Wrappers.lambdaQuery();
            lambdaQueryLike.like(LabelEntity::getName, tagName);
            tagList = characterTagMapper.selectList(lambdaQueryLike);
            if(tagList.size() == 0){
                //模糊查询也没有数据，直接返回
                return Result.OK("未查询到人物信息！",null);
            }
        }
        List<String> tagIds = new ArrayList<>();
        for (LabelEntity characterTag : tagList) {
            tagIds.add(characterTag.getId());
        }
        //根据标签列表查询人物信息
        String ids = Arrays.toString(tagIds.toArray(new String[0])).replace("[", "(").replace("]", ")");
        List<CharacterVo> list = characterTagMapper.getCharacterListByTagList(ids, offset, pageSize);
        Integer total = characterTagMapper.getCharacterListByTagCount(ids);
        Page page = new Page<>();

        page.setRecords(list);
        page.setTotal(total);
        page.setCurrent(pageNo);
        page.setSize(pageSize);

        //记录查询次数
        this.addTagTop(tagName);

        return Result.OK(page);
    }


    @Override
    public void addTagTop(CharacterTagTop characterTagTop){
        characterTagTopMapper.insert(characterTagTop);
    }

    @Override
    public Result<?> getTopTag() {
        List<String> list = characterTagMapper.getTopTag();
        return Result.OK(list);
    }

    @Override
    public SysBaseLabelTypeVo getTagTypeList() {
//        List<SysBaseLabelTypeVo> allList = new ArrayList<>();
        //SysBaseLabelTypeVo sysBaseLabelTypeVo = new SysBaseLabelTypeVo();
        //sysBaseLabelTypeVo.setId("0");
//        sysBaseLabelTypeVo.setLabelName("所有");
//        sysBaseLabelTypeVo.setPid("0");
//        sysBaseLabelTypeVo.setHasChild("1");
        List<SysBaseLabelTypeVo> list = characterTagMapper.getTagTypeListAll();
        //只获取人物服务相关的类别
        List<SysBaseLabelTypeVo> treeList = getBaseLabelTreeList(list,sys_base_label_type_id);
//        sysBaseLabelTypeVo.setChildren(treeList);
//        allList.add(sysBaseLabelTypeVo);
//        return allList;
        if(treeList.size()==1)
            return treeList.get(0);
        return null;
    }

    private void addTagTop(String tagName){

        CharacterTagTop characterTagTop = characterTagTopMapper.getByName(tagName);
        if (characterTagTop == null){
            CharacterTagTop newTagTop = new CharacterTagTop();
            newTagTop.setName(tagName);
            newTagTop.setCountNum(1);
            characterTagTopMapper.insert(newTagTop);
        } else {
            characterTagTop.setCountNum(characterTagTop.getCountNum() + 1L);
            characterTagTopMapper.updateById(characterTagTop);
        }


    }


    /**
     * 根据标签类别id查询所有的末端节点
     * @param id
     * @return
     */
    public List<SysBaseLabelType> getEndNodes(String id){
        List<SysBaseLabelType> list = new ArrayList<>();

        //SysBaseLabelType byId = super.getById(id);
        SysBaseLabelType byId = characterTagMapper.getSysBaseLabelTypeById(id);
        if (ObjectUtil.isEmpty(byId)){
            return  list;
        }
        if ("0".equals(byId.getHasChild())){
            return list;
        }

        return getnodes(list,id);
    }

    /**
     * 递归查询
     * @param list
     * @param id
     * @return
     */
    private  List<SysBaseLabelType> getnodes(List<SysBaseLabelType> list,String id){

        //List<SysBaseLabelType> child = super.list(Wrappers.<SysBaseLabelType>lambdaQuery().eq(SysBaseLabelType::getPid, id));
        List<SysBaseLabelType> child = characterTagMapper.getgetSysBaseLabelTypeListByPid(id);
        child.forEach(e -> {
            if ("0".equals(e.getHasChild())){
                list.add(e);
            }else {
                getnodes(list,e.getId());
            }
        });
        return  list;
    }

    //获取树状结构
    private List<SysBaseLabelTypeVo> getBaseLabelTreeList(List<SysBaseLabelTypeVo> baseLabelTypeList, String id){
        List<SysBaseLabelTypeVo> topList = new ArrayList<>();
        baseLabelTypeList.forEach(e->{
            if (id.equals(e.getId())) {
                topList.add(e);
            }
        });
        for (SysBaseLabelTypeVo sysLabelVo : topList) {
            setBaseLabelChildren(sysLabelVo, baseLabelTypeList);
        }
        return topList;
    }
    //递归获取树形结构数据
    private void setBaseLabelChildren(SysBaseLabelTypeVo parent, List<SysBaseLabelTypeVo> list) {
        Set<SysBaseLabelTypeVo> children = getBaseLabelChildren(list, parent.getId());
        parent.setChildren(new ArrayList<>(children));
        for (SysBaseLabelTypeVo sysLabelVo : children) {
            setBaseLabelChildren(sysLabelVo, list);
        }
    }
    private Set<SysBaseLabelTypeVo> getBaseLabelChildren(List<SysBaseLabelTypeVo> list, String id) {
        Set<SysBaseLabelTypeVo> children = new HashSet<>();
        for (SysBaseLabelTypeVo sysLabelVo : list) {
            if (sysLabelVo.getPid().equals(id)) {
                children.add(sysLabelVo);
            }
        }
        return children;
    }

}






