package com.zzsn.leaderbase.service;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson2.JSONObject;
import com.zzsn.leaderbase.util.EsDateUtil;
import com.zzsn.leaderbase.util.EsUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.time.LocalTime;
import java.util.Date;
import java.util.Map;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/16 9:45
 * @Content:
 */
@Service
@Slf4j
public class UserInfoRedisExecutorService {

    @Autowired
    private RedisTemplate redisTemplate;

    @Autowired
    private EsUtil esUtil;

    @Autowired
    IGeneratorIdService generatorIdService;


    private final static String index = "userserver_character";

    public void run(String message){

        JSONObject jsonObject = JSONObject.parseObject(message);
        //System.out.println(jsonObject);
        Map<String, String> map = jsonObject.toJavaObject(Map.class);

        String id = Long.toString(generatorIdService.getOrderId());
        map.put("id", id);
        map.put("createDate", EsDateUtil.esFieldDateFormat(DateUtil.format(new Date(), "yyyy-MM-dd hh:mm:ss")));
        esUtil.docSaveByMap(index, id, map);
        log.info("数据保存到es成功：{}---{}---{}",index, id, map.get("name"));
        //esUtil.docSaveByEntity(index, uid, vo);

    }




}
