package com.zzsn.leaderbase.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.leaderbase.entity.LabelEntity;
import com.zzsn.leaderbase.entity.SysBaseLabelType;
import com.zzsn.leaderbase.vo.CharacterVo;
import com.zzsn.leaderbase.vo.SysBaseLabelTypeVo;
import com.zzsn.leaderbase.vo.SysLabelVo;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/21 11:05
 * @Content:
 */
@Mapper
public interface CharacterTagMapper extends BaseMapper<LabelEntity> {

    List<CharacterVo> getCharacterListByTagList(String ids, Integer offset, Integer pageSize);
    Integer getCharacterListByTagCount(String ids);

    List<String> getTopTag();

    SysBaseLabelType getSysBaseLabelTypeById(String id);

    List<SysBaseLabelType> getgetSysBaseLabelTypeListByPid(String id);

    List<SysLabelVo> queryCustomLabel(List<String> ids, String name);

    List<SysBaseLabelTypeVo> getTagTypeListAll();
}
