package com.zzsn.leaderbase.service;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.leaderbase.constant.CommonConstant;
import com.zzsn.leaderbase.util.EsDateUtil;
import com.zzsn.leaderbase.util.EsUtil;
import com.zzsn.leaderbase.util.HttpUtil;
import com.zzsn.leaderbase.vo.InfoExtractionParam;
import lombok.extern.slf4j.Slf4j;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class DealLeaderDataService {
    @Autowired
    private EsUtil esUtil;
    @Value("${python.getInfoUrl}")
    private String relationEntityUrl;
    @Autowired
    RedisTemplate redisTemplate;


    public void getData() throws IOException {
        log.info("获取数据");
        Object object = redisTemplate.opsForValue().get(CommonConstant.LAST_TIME);
        String startTime = null;
        if (object != null) {
            startTime = object.toString();
        } else {
            startTime = "2023-01-01 12:12:12";
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder1 = QueryBuilders.boolQuery()
                .must(QueryBuilders.termsQuery("subjectId", Arrays.asList("1750716233967157250", "1750716067187048450")));

        boolQueryBuilder1.filter(QueryBuilders.rangeQuery("createDate").gte(EsDateUtil.esFieldDateFormat(startTime)));
        searchSourceBuilder.query(boolQueryBuilder1);
        searchSourceBuilder.sort("createDate", SortOrder.DESC);

        Integer pagesize = 1;
        for (int i = 1; true; i++) {
            Page<InfoExtractionParam> subjectdatabase = esUtil.queryPage("subjectdatabase", searchSourceBuilder, InfoExtractionParam.class, i, pagesize);
            List<InfoExtractionParam> records = subjectdatabase.getRecords();
            log.info("页码：{},总页：{},总数量{}", i, subjectdatabase.getPages(), subjectdatabase.getTotal());
            if (CollectionUtil.isNotEmpty(records)) {
                JSONObject jsonObjectParam = new JSONObject();
                Map<String, List<InfoExtractionParam>> map = new HashMap<>();
                map.put("data_list", records);
                jsonObjectParam.put("data", map);
                String result = HttpUtil.doPost(relationEntityUrl, jsonObjectParam, 10000);
                Object objectResult = parseResult(result);
                JSONObject dataResult = null;
                if (null != objectResult) {
                    dataResult = JSONObject.parseObject(objectResult.toString());
                }
                if (dataResult != null) {
                    log.info(String.valueOf(dataResult));
                }


            } else {
                log.info("此轮数据处理完毕============================================");
                break;
            }


        }
    }


    private Object parseResult(String result) {
        JSONObject jsonObject = JSONObject.parseObject(result);
        if (null != jsonObject && "200".equals(jsonObject.getString("code"))) {
            return jsonObject.get("result");

        }
        log.error("python 服务结果异常，响应信息{}", result);
        return null;
    }
}
