package com.zzsn.leaderbase.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.mapper.CharacterBasicInfoMapper;
import com.zzsn.leaderbase.service.CharacterBasicInfoService;
import com.zzsn.leaderbase.vo.CharacterListVo;
import com.zzsn.leaderbase.vo.CharacterVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 10:35
 * @Content: 人物基本信息
 */
@Service
public class CharacterBasicInfoServiceImpl extends ServiceImpl<CharacterBasicInfoMapper, CharacterBasicInfo> implements CharacterBasicInfoService {

    @Autowired
    CharacterBasicInfoMapper characterBasicInfoMapper;

    @Override
    public CharacterVo getByUid(String uid) {

        return characterBasicInfoMapper.getByUid(uid);
    }

    @Override
    public CharacterVo getById(String id) {
        return characterBasicInfoMapper.getById(id);
    }

    @Override
    public List<CharacterVo> getList(CharacterListVo characterListVo) {
        List<CharacterVo> list = characterBasicInfoMapper.getList(characterListVo);
        return list;
    }

    @Override
    public Integer getCount(CharacterListVo characterListVo) {
        return characterBasicInfoMapper.getCount(characterListVo);
    }

    @Override
    public List<CharacterVo> checkList(String articleId, String checkResult) {
        return characterBasicInfoMapper.checkList(articleId,checkResult);
    }

    @Override
    public List<CharacterVo> getListByName(String id, String name, String articleId) {
        return characterBasicInfoMapper.getListByName(id, name, articleId);
    }

    @Override
    public Integer deduplication(String duty, String company, String name) {
        Integer count = characterBasicInfoMapper.deduplication(duty, company, name);
        return count;
    }

    @Override
    public List<CharacterBasicInfo> getData(String time) {
        LambdaQueryWrapper<CharacterBasicInfo> lambdaQuery = Wrappers.lambdaQuery();
        if(!"".equals(time)){
            lambdaQuery.ge(CharacterBasicInfo::getCreateTime, time);
        }
        lambdaQuery.orderByAsc(CharacterBasicInfo::getCreateTime);
        lambdaQuery.select(CharacterBasicInfo::getUid,CharacterBasicInfo::getName);
        List<CharacterBasicInfo> list = characterBasicInfoMapper.selectList(lambdaQuery);
        return list;
    }

    @Override
    public List<CharacterVo> getPreviousDuty(String uid) {
        return characterBasicInfoMapper.getPreviousDuty(uid);
    }

    @Override
    public List<String> getCorrelationByUid(String uid) {
        return characterBasicInfoMapper.getCorrelationByUid(uid);
    }

    @Override
    public List<CharacterVo> getByOriginalId(String id) {
        return characterBasicInfoMapper.getByOriginalId(id);
    }
}
