package com.zzsn.leaderbase.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.leaderbase.entity.CisXgraPaper;
import com.zzsn.leaderbase.mapper.CisXgraPaperMapper;
import com.zzsn.leaderbase.service.CisXgraPaperService;
import com.zzsn.leaderbase.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/5 14:44
 * @Content:
 */
@Service
public class CisXgraPaperServiceImpl extends ServiceImpl<CisXgraPaperMapper, CisXgraPaper> implements CisXgraPaperService {

    @Autowired
    CisXgraPaperMapper cisXgraPaperMapper;

    @Override
    public Result<?> getCisXgraPaper(String uid) {

        LambdaQueryWrapper<CisXgraPaper> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(CisXgraPaper::getUid, uid);
        CisXgraPaper cisXgraPaper = cisXgraPaperMapper.selectOne(lambdaQuery);
        return Result.OK(cisXgraPaper);
    }
}
