package com.zzsn.leaderbase.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 人物变更信息表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("character_change_info")
public class CharacterChangeInfo {
  private static final long serialVersionUID = 1L;

  //  主键
  private String id;
  //关联人物id
  private String uid;
  //人物名称
  private String name;
  //原部门 原单位 原企业
  private String company;
  //原职务
  private String oldDuties;
  //部门 单位 企业(现)
  private String department;
  //职务(现)
  private String workplace;
  //任职时间
  private Date takeOfficeTime;
  //任职状态
  private String takeOfficeStatus;
  //变更链接
  private String changeUrl;
  //职务变更时间
  private Date dutiesUpdateTime;
  //职务变更原因
  private String dutiesUpdateReason;
  //是否审核  1是 0否
  private Long checkstatus;
  //是否审核通过 0未通过 1通过 2待定
  private Long check;
  //关联资讯id
  private String articleId;
  //关联资讯标题
  private String articleTitle;
  //变更描述
  private String updateDesc;
  //创建人
  private String createBy;
  //创建时间
  private Date createTime;
  //更新人
  private String updateBy;
  //更新时间
  private Date updateTime;
  //启停状态  1启 0停
  private Long status;

}
