package com.zzsn.leaderbase.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.leaderbase.util.EsUtil;
import com.zzsn.leaderbase.vo.RelatedReportsVo;
import com.zzsn.leaderbase.vo.Result;
import com.zzsn.leaderbase.vo.SubjectInfoVo;
import com.zzsn.leaderbase.vo.UserServerCharacterVo;
import lombok.extern.slf4j.Slf4j;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.naming.directory.SearchResult;
import java.io.IOException;
import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/20 11:06
 * @Content:
 */
@Service
@Slf4j
public class EsServer {

    @Autowired
    private EsUtil esUtil;

    private final static String USERSERVER_CHARACTER = "userserver_character";
    private final static String SUBJECTDATABASE = "subjectdatabase";


    public Result<?> getInformation(String index, String id){
        SubjectInfoVo subjectInfo = esUtil.getInfoByid(index,id, SubjectInfoVo.class);
        return Result.OK(subjectInfo);
    }

    public Result<?> getCharacterBaike(String uid, String name){
        UserServerCharacterVo vo = esUtil.getCharacterBaike(USERSERVER_CHARACTER, uid, name, UserServerCharacterVo.class);
        if(vo == null)
            return Result.OK("该人物没有详情信息", null);
        return Result.OK(vo);
    }

    public Result<?> getRelatedReportsList(RelatedReportsVo relatedReportsVo){
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        MultiMatchQueryBuilder multiMatchQueryBuilder = QueryBuilders.multiMatchQuery(relatedReportsVo.getKeyword(),  "title", "content", "summary");
        searchSourceBuilder.query(multiMatchQueryBuilder);
        searchSourceBuilder.sort("publishDate", SortOrder.DESC);
        //高亮
        //HighlightBuilder highlightBuilder = new HighlightBuilder();

        Page<SubjectInfoVo> page = null;
        try {
            page = esUtil.queryPage(SUBJECTDATABASE, searchSourceBuilder, SubjectInfoVo.class, 1, 10);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return Result.OK(page);
    }


}
