package com.zzsn.leaderbase.controller;


import com.zzsn.leaderbase.entity.CharacterCategoryStructure;
import com.zzsn.leaderbase.service.LeaderCategoryService;
import com.zzsn.leaderbase.vo.Result;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 *  分类树前端控制器
 * </p>
 *
 * @author obcy
 * @since 2024-02-27
 */
@RestController
@RequestMapping("/api/category")
public class LeaderCategoryController {
    @Autowired
    LeaderCategoryService leaderCategoryService;

    /**
     * 根据id查询分类树
     * */
    @GetMapping
    public Result<?> getById(@RequestParam(name="id",required=true) String id){
        return Result.OK(leaderCategoryService.getById(id));
    }

    /**
     * 新增分类树
     */
    @PostMapping("/add")
    public Result<?> add(@RequestBody CharacterCategoryStructure characterCategoryStructure){
       return leaderCategoryService.add(characterCategoryStructure);
    }
    /**
     * 编辑分类树
     * */
    @PostMapping("/edit")
    public Result<?> edit(@RequestBody CharacterCategoryStructure characterCategoryStructure){
       return leaderCategoryService.edit(characterCategoryStructure);
    }

    /**
     * 删除分类树
     * */
    @GetMapping("/del")
    public Result<?> del(@RequestParam(name="id",required=true) String id){
       return leaderCategoryService.del(id);
    }

    /**
     * 查询分类树列表
     * @param sign
     * @param category
     * @param pid
     * @param httpServletRequest
     * @return
     */
    @GetMapping("/list")
    public Result<?> list(
            @RequestParam(name="sign",defaultValue = "1") String sign,
            @RequestParam(name="category",required = false) String category,
            @RequestParam(name="pid",defaultValue = "0") String pid,
            HttpServletRequest httpServletRequest
                          ){
        if (!"1".equals(sign)){
            if (StringUtils.isBlank(pid)){
                return Result.error("查询非顶级节点列表时需要pid参数");
            }
        }
        return  leaderCategoryService.lists(sign,pid,category);

    }


    /**
     * 根据名称模糊查询所有节点及父节点
     * @param category
     * @param typeName
     * @return
     */
    @GetMapping("/getByName")
    public Result<?> getByName(
            @RequestParam(name="category",required = false) String category,
            @RequestParam(name="typeName",defaultValue = "0") String typeName){
        return leaderCategoryService.getByName(category,typeName);
/*
        CharacterCategoryStructureTreeVo ccs1 = new CharacterCategoryStructureTreeVo();
        ccs1.setId("1764568128651616258");
        ccs1.setTypeName("外包部门1");
        ccs1.setHasChild("0");
        ccs1.setCategory("领导人");
        ccs1.setFullPath("1764567775726100481,1764567946836926465,1764568128651616258");
        //ccs1.setChildren();

        CharacterCategoryStructureTreeVo ccs2 = new CharacterCategoryStructureTreeVo();
        ccs2.setId("1764568191536816130");
        ccs2.setTypeName("外包部门2");
        ccs2.setHasChild("0");
        ccs2.setCategory("领导人");
        ccs2.setFullPath("1764567775726100481,1764567946836926465,1764568191536816130");
//        ccs2.setChildren();

        CharacterCategoryStructureTreeVo ccs3 = new CharacterCategoryStructureTreeVo();
        ccs3.setId("1764567946836926465");
        ccs3.setTypeName("计算机与信息技术部");
        ccs3.setHasChild("1");
        ccs3.setCategory("领导人");
        ccs3.setFullPath("1764567775726100481,1764567946836926465");
        ccs3.getChildren().add(ccs1);
        ccs3.getChildren().add(ccs2);

        CharacterCategoryStructureTreeVo ccs4 = new CharacterCategoryStructureTreeVo();
        ccs4.setId("1764567775726100481");
        ccs4.setTypeName("审计局");
        ccs4.setHasChild("1");
        ccs4.setCategory("领导人");
        ccs4.setFullPath("1764567775726100481");
        ccs4.getChildren().add(ccs3);

        List<CharacterCategoryStructureTreeVo> list = new ArrayList<>();
        list.add(ccs4);

        return Result.OK(list);

 */
    }


//    @GetMapping("/type")
//    public Result<?> type(){
//        return Result.OK(KnowTypeEnum.getAllAsMap());
//    }

}
