package com.zzsn.leaderbase.entity;


import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
@TableName("character_tag")
public class CharacterTag {

  //主键
  private String id;

  //标签名称
  private String name;

  //标签编码
  private String code;

  //标签类别
  private String type;

  //分类类型:领导人、专家、企业高管
  private String category;

  //创建人
  private String createBy;

  //创建时间
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;

  //更新人
  private String updateBy;

  //更新时间
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date updateTime;

  //启停状态  1启 0停
  private long status;

  //描述
  private String description;

  //排序
  private long sort;

}
