package com.zzsn.leaderbase.controller;

import com.zzsn.leaderbase.service.CharacterTagService;
import com.zzsn.leaderbase.vo.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * 标签查询相关接口
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/20 18:26
 * @Content:
 */
@Slf4j
@RestController
@RequestMapping("/api/tag")
public class CharacterTagController {

    @Autowired
    CharacterTagService characterTagService;

    //查询标签列表

    /**
     * 查询标签列表
     * @param type
     * @param category
     * @return
     */
    @GetMapping("/getTagList")
    public Result<?> getTagList(@RequestParam(name="type",required=false) String type,
                                @RequestParam(name="category",required=false) String category){
        log.info("查询标签列表:{}---{}",type,category);
        return characterTagService.getTagList(type, category);
    }

    /**
     * 根据标签分页查询人物
     * @param tagName
     * @return
     */
    @GetMapping("/getCharacterListByTag")
    public Result<?> getCharacterListByTag(@RequestParam(name="tagName",required=true) String tagName,
                                           @RequestParam(name="pageNo",required=false) Integer pageNo,
                                           @RequestParam(name="pageSize",required=false) Integer pageSize){
        log.info("根据标签分页查询人物:{}---{}---{}",tagName,pageNo,pageSize);
        if(pageNo == null && pageNo < 1)
            pageNo = 1;
        if(pageSize == null && pageSize < 0)
            pageSize = 10;
        return characterTagService.getCharacterListByTag(tagName,pageNo,pageSize);
    }


    //热门标签
    @GetMapping("/getTopTag")
    public Result<?> getTopTag(){
        Result result = characterTagService.getTopTag();
        log.info("热门标签:{}",result.getResult());
        return result;
    }
}
