package com.zzsn.leaderbase.config;

import com.alibaba.nacos.api.exception.NacosException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;

//根据当前环境判断是否启用nacos配置
@Configuration
@ConditionalOnProperty(prefix = "spring.profiles",value = "active",havingValue = "nacos")
@EnableDiscoveryClient
@EnableFeignClients(basePackages = "com.zzsn.leaderbase.feign.api")
public class NacosConfig {
    private static final Logger log = LoggerFactory.getLogger(NacosConfig.class);
    @Value("${spring.application.name}")
    private String serviceName;
    @PostConstruct
    public void registerInstance() throws NacosException {
        log.info("nacos服务注册成功：{}",serviceName);
    }

}
