package com.zzsn.leaderbase.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.entity.CharacterBasicInfoHistory;
import com.zzsn.leaderbase.entity.CharacterChangeInfo;
import com.zzsn.leaderbase.entity.CharacterTagMap;
import com.zzsn.leaderbase.service.*;
import com.zzsn.leaderbase.util.CharacterMergeStatus;
import com.zzsn.leaderbase.vo.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 10:13
 * @Content: 人物基本信息和职务变更信息
 */
@Service
@Slf4j
public class CharacterInfoServiceImpl implements CharacterInfoService {

    @Autowired
    CharacterBasicInfoService characterBasicInfoService;
    @Autowired
    CharacterBasicInfoHistoryService characterBasicInfoHistoryService;

    @Autowired
    CharacterChangeInfoService characterChangeInfoService;

    //生成id
    @Autowired
    IGeneratorIdService generatorIdService;
    @Autowired
    CharacterMergeStatus characterMergeStatus;

    //人物标签
    @Autowired
    CharacterTagMapService characterTagMapService;


    @Override
    public Result<?> add(CharacterVo characterVo) {

        String id = Long.toString(generatorIdService.getOrderId());
        characterVo.setId(id);
        characterVo.setCreateTime(new Date());

        String uid = generatorIdService.getIdNo();
        characterVo.setUid(uid);

        Long mergeStatus = characterVo.getMergeStatus();
        if(mergeStatus == null){
            //手动添加的数据赋值为0
            characterVo.setMergeStatus(0L);
        }

        //vo对象获取转entity对象，基本信息
        CharacterBasicInfo characterBasicInfo = new CharacterBasicInfo();
        BeanUtils.copyProperties(characterVo, characterBasicInfo);
        characterBasicInfoService.save(characterBasicInfo);

        //vo对象获取转entity对象，任职变更信息
        CharacterChangeInfo characterChangeInfo = new CharacterChangeInfo();
        BeanUtils.copyProperties(characterVo, characterChangeInfo);
        characterChangeInfoService.save(characterChangeInfo);

        //标签存储
        String tagId = characterVo.getTagId();
        String[] tagIdArr = tagId.split(",");
        List<CharacterTagMap> list = new ArrayList<>();
        for (String s : tagIdArr) {
            CharacterTagMap characterTagMap = new CharacterTagMap();
            characterTagMap.setTagId(s);
            characterTagMap.setCharacterUid(characterVo.getUid());
            list.add(characterTagMap);
        }
        characterTagMapService.saveBatch(list);

       //记录任务基本信息修改记录
        CharacterBasicInfoHistory characterBasicInfoHistory = new CharacterBasicInfoHistory();
        BeanUtils.copyProperties(characterBasicInfo, characterBasicInfoHistory);
        characterBasicInfoHistory.setId(null);
        characterBasicInfoHistoryService.save(characterBasicInfoHistory);

        return Result.OK();
    }

    @Override
    public Result<?> addBulk(List<CharacterVo> list) {

        List<CharacterBasicInfo> characterBasicInfoList = new ArrayList<>();
        List<CharacterChangeInfo> characterChangeInfoList = new ArrayList<>();
        List<CharacterBasicInfoHistory> characterBasicInfoHistoryList = new ArrayList<>();
        for (CharacterVo characterVo : list) {
            String id = Long.toString(generatorIdService.getOrderId());
            characterVo.setId(id);
            characterVo.setCreateTime(new Date());
//            String uid = generatorIdService.getIdNo();
//            characterVo.setUid(uid);

            CharacterBasicInfo characterBasicInfo = new CharacterBasicInfo();
            BeanUtils.copyProperties(characterVo, characterBasicInfo);
            characterBasicInfoList.add(characterBasicInfo);

            CharacterChangeInfo characterChangeInfo = new CharacterChangeInfo();
            BeanUtils.copyProperties(characterVo, characterChangeInfo);
            characterChangeInfoList.add(characterChangeInfo);

            CharacterBasicInfoHistory characterBasicInfoHistory = new CharacterBasicInfoHistory();
            BeanUtils.copyProperties(characterBasicInfo, characterBasicInfoHistory);
            characterBasicInfoHistory.setId(null);
            characterBasicInfoHistoryList.add(characterBasicInfoHistory);
        }

        characterBasicInfoService.saveBatch(characterBasicInfoList);
        characterChangeInfoService.saveBatch(characterChangeInfoList);
        characterBasicInfoHistoryService.saveBatch(characterBasicInfoHistoryList);

        return Result.OK();
    }

    @Override
    public Result<?> getByUid(String uid) {
        return Result.OK(characterBasicInfoService.getByUid(uid));
    }

    @Override
    public Result<?> getById(String id) {
        CharacterVo characterVo = characterBasicInfoService.getById(id);
        if(characterVo == null)
            return Result.OK("未查询到人物信息",null);

        //todo 未解决问题
        String uid = characterVo.getUid();
        if(uid != null){
            Map<String, String> tagMap = characterTagMapService.getByUid(characterVo.getUid());
            if(tagMap != null){
                characterVo.setTagId(tagMap.get("tag_id"));
                characterVo.setTagName(tagMap.get("tag_name"));
            }
        }

        return Result.OK(characterVo);
    }

    @Override
    public Result<?> edit(CharacterVo characterVo) {

        characterVo.setUpdateTime(new Date());

        //vo对象获取转entity对象，基本信息
        CharacterBasicInfo characterBasicInfo = new CharacterBasicInfo();
        BeanUtils.copyProperties(characterVo, characterBasicInfo);
        characterBasicInfoService.updateById(characterBasicInfo);

        //vo对象获取转entity对象，任职变更信息
        CharacterChangeInfo characterChangeInfo = new CharacterChangeInfo();
        BeanUtils.copyProperties(characterVo, characterChangeInfo);
        characterChangeInfoService.updateById(characterChangeInfo);

        //标签修改
        String uid = characterVo.getUid();
        if(uid != null){
            //删除原有的
            characterTagMapService.delByUid(characterVo.getUid());
            //增加新的
            String tagId = characterVo.getTagId();
            String[] tagIdArr = tagId.split(",");
            List<CharacterTagMap> list = new ArrayList<>();
            for (String s : tagIdArr) {
                CharacterTagMap characterTagMap = new CharacterTagMap();
                characterTagMap.setTagId(s);
                characterTagMap.setCharacterUid(characterVo.getUid());
                list.add(characterTagMap);
            }
            characterTagMapService.saveBatch(list);
        }

//        关联信息修改
//        String uid = characterVo.getUid();
//        List<String> listId = characterBasicInfoService.getCorrelationByUid(uid);
//        for (String s : listId) {
//            characterBasicInfo.setId(s);
//            characterBasicInfoService.updateById(characterBasicInfo);
//        }

        //记录人物基本信息修改记录
        CharacterBasicInfoHistory characterBasicInfoHistory = new CharacterBasicInfoHistory();
        BeanUtils.copyProperties(characterBasicInfo, characterBasicInfoHistory);
        characterBasicInfoHistory.setId(null);
        characterBasicInfoHistory.setCreateTime(new Date());
        characterBasicInfoHistoryService.save(characterBasicInfoHistory);

        return Result.OK();
    }

    @Override
    public Result<?> del(String id) {

        characterBasicInfoService.removeById(id);
        characterChangeInfoService.removeById(id);
        return Result.OK();
    }

    @Override
    public Result<?> getList(CharacterListVo characterListVo) {
        IPage page = new Page();

        //根据条件查询数据
        List<CharacterVo> list = characterBasicInfoService.getList(characterListVo);

        page.setRecords(list);
        //查询总数
        Integer total = characterBasicInfoService.getCount(characterListVo);
        page.setTotal(total);
        Integer pageNo = characterListVo.getPageNo();
        Integer pageSize= characterListVo.getPageSize();
        page.setCurrent(pageNo);
        page.setSize(pageSize);

        return Result.OK(page);
    }

    @Override
    public boolean deduplication(String curStation, String curWorkPlace, String person) {
        Integer count = characterBasicInfoService.deduplication(curStation, curWorkPlace, person);
        if(count == 0){
            //数据不重复，返回false
            return false;
        } else {
            return true;
        }
    }


    @Override
    public Result<?> checkList(String articleId, String[] checkResultArr) {

        String checkResult = "";
        if(checkResultArr != null && checkResultArr.length != 0)
            checkResult = Arrays.toString(checkResultArr).replace("[", "(").replace("]", ")");
        List<CharacterVo> list = new ArrayList<>();
        //当关联多个资讯id时时使用逗号分隔的
        String[] articleIdsArr = articleId.split(",");
        for (String article : articleIdsArr) {
            List<CharacterVo> characterVoList = characterBasicInfoService.checkList(article,checkResult);
            list.addAll(characterVoList);
        }
        return Result.OK(list);
    }

    /**
     * 审核根据姓名查询同名人物，排除当前人物，当前资讯人物
     * @param id
     * @param name
     * @param articleId
     * @return
     */
    @Override
    public Result<?> getListByName(String id, String name, String articleId) {

        List<CharacterVo> list = characterBasicInfoService.getListByName(id, name, articleId);

        return Result.OK(list);

    }

    /**
     * 审核
     * @param characterCheckVo
     * @return
     */
    @Override
    public Result<?> checkUpdate(CharacterCheckVo characterCheckVo) {

        //原人物信息
        CharacterVo originalCharacter = characterCheckVo.getOriginalCharacter();
        //新人物信息
        CharacterVo character = characterCheckVo.getCharacter();
        character.setCheckStatus(1L);

        //更新职务信息
        //获取新的人物对象
        CharacterVo characterVoNew = characterMergeStatus.mergeNew(originalCharacter, character);


        //保存数据
        //vo对象获取转entity对象，基本信息
        CharacterBasicInfo characterBasicInfo = new CharacterBasicInfo();
        BeanUtils.copyProperties(characterVoNew, characterBasicInfo);
        characterBasicInfoService.save(characterBasicInfo);

        //vo对象获取转entity对象，任职变更信息
        CharacterChangeInfo characterChangeInfo = new CharacterChangeInfo();
        BeanUtils.copyProperties(characterVoNew, characterChangeInfo);
        characterChangeInfoService.save(characterChangeInfo);

        //合并前的数据状态修改为停用
        CharacterChangeInfo cci1 = new CharacterChangeInfo();
        cci1.setId(originalCharacter.getId());
        cci1.setStatus(0L);
        characterChangeInfoService.updateById(cci1);
        CharacterChangeInfo cci2 = new CharacterChangeInfo();
        cci2.setId(character.getId());
        cci2.setStatus(0L);
        characterChangeInfoService.updateById(cci2);

        //记录人物基本信息修改记录
        CharacterBasicInfoHistory characterBasicInfoHistory = new CharacterBasicInfoHistory();
        BeanUtils.copyProperties(characterBasicInfo, characterBasicInfoHistory);
        characterBasicInfoHistory.setId(null);
        characterBasicInfoHistoryService.save(characterBasicInfoHistory);

        return Result.OK(characterVoNew);
    }

    /**
     * 取消审核
     * @param id
     * @return
     */
    @Override
    public Result<?> checkCancelUpdate(String id) {
        //根据id查询人物信息
        CharacterVo characterVo = characterBasicInfoService.getById(id);
        if(characterVo == null){
            log.info("根据id未查询到人物信息：{}", id);
            return Result.error("未查询到人物信息!");
        }
        //审核信息 原人物id
        String originalId = characterVo.getOriginalId();
        //审核信息 新人物id
        String newId = characterVo.getNewId();
        //审核信息 1:更新人物  2:添加职位
//        Long mergeStatus = characterVo.getMergeStatus();
//        if (originalId == null || newId == null){
//            log.info("数据有误：{}---{}---{}", originalId, newId, mergeStatus);
//            return Result.error("数据有误！");
//        }
        //恢复合并前的人物为启用
        //合并前的数据状态修改为停用
        List<CharacterChangeInfo> updateList = new ArrayList<>();
        CharacterChangeInfo cci1 = new CharacterChangeInfo();
        cci1.setId(originalId);
        cci1.setStatus(1L);
        characterChangeInfoService.updateById(cci1);
        updateList.add(cci1);
        CharacterChangeInfo cci2 = new CharacterChangeInfo();
        cci2.setId(newId);
        cci2.setStatus(1L);
        updateList.add(cci2);
        characterChangeInfoService.updateById(cci1);

        //characterChangeInfoService.updateBatchById(updateList);

        //删除合并人物
        characterBasicInfoService.removeById(id);
        characterChangeInfoService.removeById(id);

        //查询新人物返回
        CharacterVo characterById = characterBasicInfoService.getById(newId);
        return Result.OK(characterById);
    }

    @Override
    public Result<?> merge(CharacterMergeVo characterMergeVo) {
        Result result = Result.OK();
        Long type = characterMergeVo.getType();
        String originalId = characterMergeVo.getOriginalId();
        String newId = characterMergeVo.getNewId();
        CharacterVo characterVo = characterMergeVo.getCharacter();
        if(type == 1L){
            if(originalId == null || originalId.length() == 0 || newId == null || newId.length() == 0){
                result = Result.error("合并人物时原人物id和新人物id不能为空！");
            }
            result = mergeType1(originalId, newId, characterVo);
        } else if(type == 2L){
            result = mergeType2(characterVo);
        } else if(type == 3L){
            if(originalId == null || originalId.length() == 0){
                result =  Result.error("追加历任职务原人物id不能为空！");
            }
            result = mergeType3(originalId, characterVo);
        } else {
            result = Result.error("参数type有误！");
        }
        return result;
    }

    @Override
    public Result<?> mergeCancel(String id) {
        //根据id查询数据
        CharacterVo characterVo = characterBasicInfoService.getById(id);
        if(characterVo == null){
            return Result.error("根据id未查询到人物信息");
        }
        Long type = characterVo.getMergeStatus();
        if(type == 1L){
            //删除当前数据
            characterBasicInfoService.removeById(id);
            characterChangeInfoService.removeById(id);

            //恢复合并前的数据为可用状态
            String originalId = characterVo.getOriginalId();
            String newId = characterVo.getNewId();
            CharacterChangeInfo cci1 = new CharacterChangeInfo();
            cci1.setId(originalId);
            cci1.setStatus(1L);
            characterChangeInfoService.updateById(cci1);
            CharacterChangeInfo cci2 = new CharacterChangeInfo();
            cci2.setId(newId);
            cci2.setStatus(1L);
            characterChangeInfoService.updateById(cci2);

        } else if(type == 2L){
            //删除当前数据
            characterBasicInfoService.removeById(id);
            characterChangeInfoService.removeById(id);
            //恢复合并前的数据为可用状态
            String originalId = characterVo.getOriginalId();
            CharacterChangeInfo cci1 = new CharacterChangeInfo();
            cci1.setId(originalId);
            cci1.setStatus(1L);
            characterChangeInfoService.updateById(cci1);

        } else if(type == 3L){

            //解绑人物uid
            characterVo.setUid("");
            //状态为可用
            characterVo.setStatus(1L);
            //type状态取消
            characterVo.setMergeStatus(-1L);
            //审核状态置为未审核
            characterVo.setCheckResult(-1L);
            this.edit(characterVo);
        } else {
            return Result.error("参数type有误！");
        }

        return Result.OK();
    }

    @Override
    public Result<?> getPreviousDuty(String uid) {
        return Result.OK(characterBasicInfoService.getPreviousDuty(uid));
    }

    @Override
    public Result<?> correlation(CharacterVo characterVo) {
        String id = characterVo.getId();
        if(id == null || "".equals(id))
            return Result.error("id不能为空！");
        CharacterVo vo = characterBasicInfoService.getById(id);
        if(characterVo == null)
            return Result.error("人物不存在！");

        //新增一条基本信息，取库中最新的数据
        CharacterBasicInfo characterBasicInfo = new CharacterBasicInfo();
        BeanUtils.copyProperties(vo, characterBasicInfo);
        String newId = Long.toString(generatorIdService.getOrderId());
        characterBasicInfo.setId(newId);
        characterBasicInfoService.save(characterBasicInfo);

        //新增关联的任职记录
        //vo对象获取转entity对象，任职变更信息
        CharacterChangeInfo characterChangeInfo = new CharacterChangeInfo();
        BeanUtils.copyProperties(characterVo, characterChangeInfo);
        characterChangeInfo.setId(newId);
        characterChangeInfo.setUid(vo.getUid());
        characterChangeInfo.setUid(vo.getName());
        characterChangeInfo.setCheckResult(1L);
        characterChangeInfo.setStatus(2L);
        characterChangeInfoService.save(characterChangeInfo);
        return Result.OK();
    }

    @Override
    public Result<?> correlationEdit(CharacterVo characterVo) {

        //关联编辑只设计职务部分的修改，基本信息的修改不涉及
        characterVo.setUpdateTime(new Date());
        //vo对象获取转entity对象，任职变更信息
        CharacterChangeInfo characterChangeInfo = new CharacterChangeInfo();
        BeanUtils.copyProperties(characterVo, characterChangeInfo);
        characterChangeInfoService.updateById(characterChangeInfo);
        return Result.OK();
    }


    /**
     * 1合并人物
     */
    private Result<?> mergeType1(String originalId, String newId, CharacterVo characterVo){
        String id = Long.toString(generatorIdService.getOrderId());
        characterVo.setId(id);
        //合并人物，若uid为空则从数据库查询
        String uid = characterVo.getUid();
        if(uid == null || uid.length() == 0){
            CharacterVo originalCharacter = characterBasicInfoService.getById(originalId);
            characterVo.setUid(originalCharacter.getUid());
        }
        characterVo.setOriginalId(originalId);
        characterVo.setNewId(newId);
        characterVo.setMergeStatus(1L);
        saveCharacterBasicInfo(characterVo);

        //修改原人物信息为停用
        CharacterChangeInfo cci1 = new CharacterChangeInfo();
        cci1.setId(originalId);
        cci1.setStatus(0L);
        characterChangeInfoService.updateById(cci1);

        CharacterChangeInfo cci2 = new CharacterChangeInfo();
        cci2.setId(newId);
        cci2.setStatus(0L);
        characterChangeInfoService.updateById(cci2);

        return Result.OK();
    }

    //2新增人物
    private Result<?> mergeType2(CharacterVo characterVo){
        String originalId = characterVo.getId();
        if(originalId == null || originalId.length() == 0){
            return Result.error("主键id不能为空！");
        }

        String id = Long.toString(generatorIdService.getOrderId());
        characterVo.setId(id);
        //新增人物，若uid为空则生成uid
        String uid = characterVo.getUid();
        if(uid == null || uid.length() == 0){
            characterVo.setUid(generatorIdService.getIdNo());
        }
        characterVo.setMergeStatus(2L);
        characterVo.setOriginalId(originalId);
        saveCharacterBasicInfo(characterVo);

        //修改原人物信息为停用
        CharacterChangeInfo cci1 = new CharacterChangeInfo();
        cci1.setId(originalId);
        cci1.setStatus(0L);
        characterChangeInfoService.updateById(cci1);

        return Result.OK();
    }

    //3追加历任职务
    private Result<?> mergeType3(String originalId, CharacterVo characterVo){
        //uid
        String uid = characterVo.getUid();
        if(uid == null || uid.length() == 0){
            CharacterVo originalCharacter = characterBasicInfoService.getById(originalId);
            characterVo.setUid(originalCharacter.getUid());
        }
        characterVo.setMergeStatus(3L);
        characterVo.setStatus(0L);
        this.edit(characterVo);

        return Result.OK();
    }


    /**
     * 根据vo保存人物基本信息和任职信息
     * 并记录基本信息修改
     * @param characterVo
     */
    private void saveCharacterBasicInfo(CharacterVo characterVo){
        //vo对象获取转entity对象，基本信息
        CharacterBasicInfo characterBasicInfo = new CharacterBasicInfo();
        BeanUtils.copyProperties(characterVo, characterBasicInfo);
        characterBasicInfoService.save(characterBasicInfo);

        //vo对象获取转entity对象，任职变更信息
        CharacterChangeInfo characterChangeInfo = new CharacterChangeInfo();
        BeanUtils.copyProperties(characterVo, characterChangeInfo);
        characterChangeInfoService.save(characterChangeInfo);

        //记录任务基本信息修改记录
        CharacterBasicInfoHistory characterBasicInfoHistory = new CharacterBasicInfoHistory();
        BeanUtils.copyProperties(characterBasicInfo, characterBasicInfoHistory);
        characterBasicInfoHistory.setId(null);
        characterBasicInfoHistoryService.save(characterBasicInfoHistory);
    }
}
