package com.zzsn.leaderbase.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.leaderbase.util.EsDateUtil;
import com.zzsn.leaderbase.util.EsUtil;
import com.zzsn.leaderbase.vo.RelatedReportsVo;
import com.zzsn.leaderbase.vo.Result;
import com.zzsn.leaderbase.vo.SubjectInfoVo;
import com.zzsn.leaderbase.vo.UserServerCharacterVo;
import lombok.extern.slf4j.Slf4j;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.naming.directory.SearchResult;
import java.io.IOException;
import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/20 11:06
 * @Content:
 */
@Service
@Slf4j
public class EsServer {

    @Autowired
    private EsUtil esUtil;

    private final static String USERSERVER_CHARACTER = "userserver_character";
    private final static String SUBJECTDATABASE = "subjectdatabase";


    public Result<?> getInformation(String index, String id){
        SubjectInfoVo subjectInfo = esUtil.getInfoByid(index,id, SubjectInfoVo.class);
        return Result.OK(subjectInfo);
    }

    public Result<?> getCharacterBaike(String uid, String name){

        //参数校验
        if((uid == null || uid.length() == 0) && (name == null || name.length() == 0))
            return Result.OK("未查询到人物详情信息", null);

        UserServerCharacterVo vo = esUtil.getCharacterBaike(USERSERVER_CHARACTER, uid, name, UserServerCharacterVo.class);
        if(vo == null)
            return Result.OK("未查询到人物详情信息", null);
        return Result.OK(vo);
    }

    public Result<?> getRelatedReportsList(RelatedReportsVo relatedReportsVo){
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        //MultiMatchQueryBuilder multiMatchQueryBuilder = QueryBuilders.multiMatchQuery(relatedReportsVo.getKeyword(),  "title", "content", "summary");
        //searchSourceBuilder.query(multiMatchQueryBuilder);
//        searchSourceBuilder.query(QueryBuilders.termQuery("content", relatedReportsVo.getKeyword()));
        searchSourceBuilder.sort("publishDate", SortOrder.DESC);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery()
                .should(QueryBuilders.wildcardQuery("contentWithTag.keyword", "*"+relatedReportsVo.getKeyword()+"*"))
                .should(QueryBuilders.wildcardQuery("summary.keyword", "*"+relatedReportsVo.getKeyword()+"*"))
                .should(QueryBuilders.wildcardQuery("title.keyword", "*"+relatedReportsVo.getKeyword()+"*"))
                ;
        searchSourceBuilder.query(boolQuery);

        Page<SubjectInfoVo> page = null;
        try {
            page = esUtil.queryPageSubjectInfoVo(SUBJECTDATABASE, searchSourceBuilder, relatedReportsVo.getPageNo(), relatedReportsVo.getPageSize());
        } catch (IOException e) {
            e.printStackTrace();
        }
        for (SubjectInfoVo record : page.getRecords()) {
            record.setPublishDate(EsDateUtil.esFieldDateMapping(record.getPublishDate()));
        }
        return Result.OK(page);
    }


}
