package com.zzsn.leaderbase.service;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.leaderbase.constant.CommonConstant;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.entity.SysBaseDomesticRegion;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/15 15:40
 * @Content:
 */
@Service
@Slf4j
public class UserInfoExecutorService {

    @Autowired
    private RedisTemplate redisTemplate;

    @Autowired
    CharacterBasicInfoService characterBasicInfoService;



    private final static String USER_INFO_TIME = "USER_INFO_TIME"; //"2024-03-15 10:16:45"
    private final static String USER_INFO_LIST = "USER_INFO_LIST";

    public void run(){
        Object object = redisTemplate.opsForValue().get(USER_INFO_TIME);
        redisTemplate.opsForValue().set(USER_INFO_TIME, DateUtil.format(new Date(),"yyyy-MM-dd HH:mm:ss"));
        String time = "";
        if (object != null) {
            time = object.toString();
        }
        log.info("USER_INFO_TIME time:{}", time);
        List<CharacterBasicInfo> list = characterBasicInfoService.getData(time);
        log.info("查询需要采集的人物数量：{}", list.size());
        for (CharacterBasicInfo characterBasicInfo : list) {
            String uid = characterBasicInfo.getUid();
            String name = characterBasicInfo.getName();
            BoundListOperations listOps = redisTemplate.boundListOps(USER_INFO_LIST);
            String value = uid + "|" + name + "|";
            listOps.rightPush(uid + "|" + name + "|");
            log.info("To Redis USER_INFO_LIST value:{}", value);
        }
    }
}
