package com.zzsn.leaderbase.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.leaderbase.constant.CommonConstant;
import com.zzsn.leaderbase.util.EsDateUtil;
import com.zzsn.leaderbase.util.EsUtil;
import com.zzsn.leaderbase.util.HttpUtil;
import com.zzsn.leaderbase.vo.CharacterVo;
import com.zzsn.leaderbase.vo.InfoExtractionParam;
import lombok.extern.slf4j.Slf4j;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.*;

@Service
@Slf4j
public class DealLeaderDataService {
    @Autowired
    private EsUtil esUtil;
    @Value("${python.getInfoUrl}")
    private String relationEntityUrl;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private CharacterInfoService characterInfoService;



    public void getData() throws IOException {
        log.info("获取数据");
        Object object = redisTemplate.opsForValue().get(CommonConstant.LAST_TIME);
        String startTime = null;
        if (object != null) {
            startTime = object.toString();
        } else {
            startTime = "2023-01-01 12:12:12";
        }
        //startTime = "2023-01-01 12:12:12";
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder1 = QueryBuilders.boolQuery()
                .must(QueryBuilders.termsQuery("subjectId", Arrays.asList("1750716233967157250", "1750716067187048450")))
                ;

        boolQueryBuilder1.filter(QueryBuilders.rangeQuery("createDate").gte(EsDateUtil.esFieldDateFormat(startTime)));
        searchSourceBuilder.query(boolQueryBuilder1);
        searchSourceBuilder.sort("createDate", SortOrder.DESC);

        Integer pagesize =5;
        for (int i = 1; true; i++) {
            Page<InfoExtractionParam> subjectdatabase = esUtil.queryPageInfoExtractionParam("subjectdatabase", searchSourceBuilder,  i, pagesize);
            List<InfoExtractionParam> records = subjectdatabase.getRecords();
            log.info("页码：{},总页：{},总数量{}", i, subjectdatabase.getPages(), subjectdatabase.getTotal());

            if (CollectionUtil.isNotEmpty(records)) {
                JSONObject jsonObjectParam = new JSONObject();

                Map<String, String> idIndexMap = new HashMap<>();
                for (InfoExtractionParam record : records) {
                    idIndexMap.put(record.getId(), record.getIndex());
                }

                for (InfoExtractionParam record : records) {
                    List<CharacterVo> list = new ArrayList<>();
                    Map<String, List<InfoExtractionParam>> map = new HashMap<>();
                    map.put("data_list", Collections.singletonList(record));
                    jsonObjectParam.put("data", map);
                    log.info("request");
                    String result = HttpUtil.doPost(relationEntityUrl, jsonObjectParam, 40000);
                    log.info("response:{}", result);
                    Object objectResult = parseResult(result);
                    JSONArray dataResultList = null;
                    if (null != objectResult) {
                        dataResultList = (JSONArray) JSONArray.parse(objectResult.toString());
                    }
                    if (dataResultList != null) {
                        for (Object dataResultObject : dataResultList) {
                            JSONObject dataResult = JSONObject.parseObject(dataResultObject.toString());
                            if (dataResult.get("infos") != null) {
                                String id = String.valueOf(dataResult.get("id"));
                                JSONArray jsonArray = (JSONArray) JSONArray.parse(String.valueOf(dataResult.get("infos")));
                                for (Object data : jsonArray) {
                                    JSONObject temp = JSONObject.parseObject(data.toString());
                                    boolean b = characterInfoService.deduplication(temp.get("curStation") != null ? temp.get("curStation").toString() : "",
                                            temp.get("curWorkPlace") != null ? temp.get("curWorkPlace").toString() : "",
                                            temp.get("person") != null ? temp.get("person").toString() : "");
                                    if(b){
                                        log.info("数据重复：{}",data.toString());
                                    } else {
                                        list.add(CharacterVo.builder()
                                                //curStation curWorkPlace person
                                                .category("领导人")
                                                .updateDesc(temp.get("updateDesc") != null ? temp.get("updateDesc").toString() : "")
                                                .takeOfficeStatus("在职")
                                                .dutyOriginal(temp.get("oriStation") != null ? temp.get("oriStation").toString() : "")
                                                .duty(temp.get("curStation") != null ? temp.get("curStation").toString() : "")
                                                .companyOriginal(temp.get("oriWorkPlace") != null ? temp.get("oriWorkPlace").toString() : "")
                                                .company(temp.get("curWorkPlace") != null ? temp.get("curWorkPlace").toString() : "")
                                                .name(temp.get("person") != null ? temp.get("person").toString() : "")
                                                .articleId(dataResult.get("id") != null ? dataResult.get("id").toString() : "")
                                                .articleIndex(dataResult.get("id") != null ? idIndexMap.get("id") : "")
                                                .checkStatus(0L)
                                                .createTime(new Date())
                                                .build());
                                    }
                                }
                            }
                        }
                    }
                    if (!list.isEmpty()) {
                        try {
                            log.info("inserting");
                            characterInfoService.addBulk(list);
                        }catch (Exception e){
                            log.error("异常：{}",e.getMessage());
                        }

                    }
                }

            } else {
                log.info("此轮数据处理完毕============================================");
                break;
            }
            redisTemplate.opsForValue().set(CommonConstant.LAST_TIME, DateUtil.format(new Date(),"yyyy-MM-dd HH:mm:ss"));

        }
    }


    private Object parseResult(String result) {
        JSONObject jsonObject = JSONObject.parseObject(result);
        if (null != jsonObject && "true".equals(jsonObject.getString("isHandleSuccess"))) {
            return jsonObject.get("resultData");

        }
        log.error("python 服务结果异常，响应信息{}", result);
        return null;
    }
}
