package com.zzsn.leaderbase.config;

import com.zzsn.leaderbase.service.DealLeaderDataService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@Slf4j
@Component
public class TaskExecutor  implements CommandLineRunner {
    ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    private final Integer PERIOD=60*60;//定时任务秒数

    @Autowired
    private DealLeaderDataService dealLeaderDataService;
    @Override
    public void run(String... args)throws Exception {
        scheduledExecutorService.scheduleAtFixedRate(()->{
            try {
                dealLeaderDataService.getData();
            } catch (IOException e) {
                e.printStackTrace();
            }
        },5,PERIOD, TimeUnit.SECONDS);

        log.info("采集资讯抽取定时任务启动成功！{}---{}执行一次",PERIOD,TimeUnit.SECONDS);
    }
}
