package com.zzsn.leaderbase.service.impl;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.leaderbase.entity.CharacterCategoryStructure;
import com.zzsn.leaderbase.mapper.LeaderCategoryMapper;
import com.zzsn.leaderbase.service.LeaderCategoryService;
import com.zzsn.leaderbase.vo.Result;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * <p>
 *  分类树服务实现类
 * </p>
 *
 * @author
 * @since
 */
@Service
public class LeaderCategoryServiceImpl extends ServiceImpl<LeaderCategoryMapper, CharacterCategoryStructure> implements LeaderCategoryService {

    @Override
    @Transactional
    public Result<?> add(CharacterCategoryStructure characterCategoryStructure) {
        //判断是否有父节点，没有则为根节点，pid的值为0
        if (StringUtils.isBlank(characterCategoryStructure.getPid())){
            characterCategoryStructure.setPid(LeaderCategoryService.ROOT_PID_VALUE);
        }else {
            CharacterCategoryStructure parent = super.getById(characterCategoryStructure.getPid());
            if(parent!=null && !LeaderCategoryService.HASCHILD.equals(parent.getHasChild())){
                parent.setHasChild(LeaderCategoryService.HASCHILD);
                super.updateById(parent);
            }
        }
        //characterCategoryStructure.setStatus(0);
        characterCategoryStructure.setHasChild(LeaderCategoryService.NOCHILD);
        /**第一次保存赋默认值*/
        characterCategoryStructure.setFullPath("0");
        characterCategoryStructure.setCreateTime(new Date());
        super.save(characterCategoryStructure);
        if (LeaderCategoryService.ROOT_PID_VALUE.equals(characterCategoryStructure.getPid())){
            characterCategoryStructure.setFullPath(characterCategoryStructure.getId());
        }else {
            CharacterCategoryStructure parent = super.getById(characterCategoryStructure.getPid());
            characterCategoryStructure.setFullPath(parent.getFullPath() +","+ characterCategoryStructure.getId());
        }
        super.updateById(characterCategoryStructure);
        return Result.OK();
    }


    @Override
    @Transactional
    public Result<?> edit(CharacterCategoryStructure characterCategoryStructure) {
        CharacterCategoryStructure byId = super.getById(characterCategoryStructure.getId());
        if (ObjectUtils.isEmpty(byId)){
            return Result.error("未找到对应的分类id");
        }
        String oldPid = byId.getPid();
        String newPid = characterCategoryStructure.getPid();
        if(!oldPid.equals(newPid)) {
            /**处理之前父节点的hasChild字段*/
            updateOldParentNode(oldPid);

            if(StringUtils.isBlank(newPid) || LeaderCategoryService.ROOT_PID_VALUE.equals(newPid)){
                characterCategoryStructure.setPid(LeaderCategoryService.ROOT_PID_VALUE);
                newPid = characterCategoryStructure.getPid();
            }
            /**处理新的父节点的hasChild字段*/
            if(!LeaderCategoryService.ROOT_PID_VALUE.equals(characterCategoryStructure.getPid())) {
                super.update(Wrappers.<CharacterCategoryStructure>lambdaUpdate().set(CharacterCategoryStructure::getHasChild,LeaderCategoryService.HASCHILD).eq(CharacterCategoryStructure::getId,newPid));
            }
            characterCategoryStructure.setUpdateTime(new Date());
            super.updateById(characterCategoryStructure);


            /**处理本节点的所有子节点的绝对路径*/
            List<CharacterCategoryStructure> list = super.list(Wrappers.<CharacterCategoryStructure>lambdaQuery().like(CharacterCategoryStructure::getFullPath,characterCategoryStructure.getId()));
            if (CollectionUtil.isNotEmpty(list)){
                String finalNewPid = newPid;
                if (!LeaderCategoryService.ROOT_PID_VALUE.equals(finalNewPid)) {
                    /**非根节点 移动到其他非根节点*/
                    CharacterCategoryStructure projectPid = super.getById(finalNewPid);

                    if (!LeaderCategoryService.ROOT_PID_VALUE.equals(oldPid)) {
                        String id = characterCategoryStructure.getId();
                        String fullPath = characterCategoryStructure.getFullPath();
                        String replace = fullPath.replace(id, "");

                        list.forEach(e->{
                            e.setFullPath(projectPid.getFullPath()+"," + e.getFullPath().replace(replace, ""));
                        });
                    }else {
                        /**根节点 移动到其他非根节点*/
                        list.forEach(e->{
                            e.setFullPath(projectPid.getFullPath()+","+e.getFullPath());
                        });
                    }
                }else {
                    String id = characterCategoryStructure.getId();
                    String fullPath = characterCategoryStructure.getFullPath();
                    String replace = fullPath.replace(id, "");
                    /**移动到根节点*/
                    list.forEach(e->{
                        e.setFullPath(e.getFullPath().replace(replace, ""));
                    });
                }
            }
            super.updateBatchById(list);
        }else {
            characterCategoryStructure.setUpdateTime(new Date());
            super.updateById(characterCategoryStructure);
        }
        return Result.OK();

    }

    @Override
    public Result<?> del(String id) {
        CharacterCategoryStructure byId = super.getById(id);
        super.remove(Wrappers.<CharacterCategoryStructure>lambdaQuery().like(CharacterCategoryStructure::getFullPath,id));
        if (StringUtils.isNotBlank(byId.getPid())&&!LeaderCategoryService.ROOT_PID_VALUE.equals(byId.getPid())){
            updateOldParentNode(byId.getPid());
        }
        return Result.OK();
    }


    @Override
    public Result<?> lists(String sign, String pid, String category) {

            List<CharacterCategoryStructure> characterCategoryStructure ;
            if ("1".equals(sign)&&"0".equals(pid)){
                characterCategoryStructure = super.list(Wrappers.<CharacterCategoryStructure>lambdaQuery()
                        .eq(CharacterCategoryStructure::getPid, LeaderCategoryService.ROOT_PID_VALUE)
                        .eq(StrUtil.isNotBlank(category),CharacterCategoryStructure::getCategory,category));
            }else {
                characterCategoryStructure = super.list(Wrappers.<CharacterCategoryStructure>lambdaQuery()
                        .eq(CharacterCategoryStructure::getPid,pid)
                        .eq(StrUtil.isNotBlank(category),CharacterCategoryStructure::getCategory,category));
            }
            return Result.OK(characterCategoryStructure);

    }


    private void updateOldParentNode(String pid) {
        if(!LeaderCategoryService.ROOT_PID_VALUE.equals(pid)) {
            Integer count = baseMapper.selectCount(Wrappers.<CharacterCategoryStructure>lambdaQuery().eq(CharacterCategoryStructure::getPid,pid));
            if(count==null || count<=1) {
                super.update(Wrappers.<CharacterCategoryStructure>lambdaUpdate().set(CharacterCategoryStructure::getHasChild,LeaderCategoryService.NOCHILD).eq(CharacterCategoryStructure::getId,pid));
            }
        }
    }

}
