package com.zzsn.leaderbase.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
@TableName("learning_achievement")
public class LearningAchievement extends Model<LearningAchievement> {

  //主键
  @TableId(value = "id", type = IdType.ASSIGN_ID)
  private String id;
  //'关联人物id'
  private String uid;
  //'标题 题名'
  private String title;
  //'作者'
  private String author;
  //'摘要'
  private String summary;
  //'来源 机构'
  private String origin;
  //'刊名'
  private String journal;
  //'ISSN号'
  private String issnCode;
  //'CN号'
  private String cnCode;
  //'馆藏号'
  private String collectionCode;
  //'关键词'
  private String keyword;
  //'载体类型 期刊、会议、专利'
  private String carrierType;
  //'出版周期'
  private String publishingCycle;
  //'引用数'
  private Long citeCount;
  //'下载数'
  private Long downloadCount;
  //'发表时间'
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date publishData;
  //'附注'
  private String annotations;
  //'创建人'
  private String createBy;
  //'创建时间'
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  //'更新人'
  private String updateBy;
  //'更新时间'
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date updateTime;
  //'启停状态  1启 0停'
  private Long status;

}
