package com.zzsn.leaderbase;

import com.zzsn.leaderbase.config.TaskExecutor;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.scheduling.annotation.EnableAsync;

@SpringBootApplication
@EnableAsync
@MapperScan(value = {"com.zzsn.leaderbase.mapper*"})
@EnableKafka
public class LeaderBaseApplication {

    public static void main(String[] args) {
        SpringApplication.run(LeaderBaseApplication.class, args);
    }
    @Bean
    public TaskExecutor schedulerRunner() {
        return new TaskExecutor();
    }
}
