package com.zzsn.leaderbase.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.vo.CharacterListVo;
import com.zzsn.leaderbase.vo.CharacterVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 10:36
 * @Content:
 */
@Mapper
public interface CharacterBasicInfoMapper extends BaseMapper<CharacterBasicInfo> {

    @Select("select " +
            "a.id,a.uid,a.name,a.sex,a.birthplace,a.birthday,a.native_place,a.school,a.speciality,a.education,a.expert_occupation,a.head_sculpture,a.biographical_notes,a.category,a.award_records,a.part_time_job,a.research_field,a.evaluate,a.status," +
            "b.type_id,c.type_name,b.company_original,b.department_original,b.duty_original,b.company,b.department,b.duty,b.take_office_time,b.take_office_time_end,b.take_office_status,b.change_url,b.duties_update_time,b.duties_update_reason,b.check_status,b.check_result,b.article_id,b.article_title,b.update_desc,b.original_id,b.new_id,b.merge_status,a.create_by,a.create_time,a.update_by,a.update_time " +
            "from character_basic_info a " +
            "INNER JOIN character_change_info b " +
            "on a.id = b.id " +
            "LEFT JOIN character_category_structure c " +
            "ON b.type_id = c.id " +
            "where a.uid = #{uid}")
    CharacterVo getByUid(String uid);

    @Select("select " +
            "a.id,a.uid,a.name,a.sex,a.birthplace,a.birthday,a.native_place,a.school,a.speciality,a.education,a.expert_occupation,a.head_sculpture,a.biographical_notes,a.category,a.award_records,a.part_time_job,a.research_field,a.evaluate,a.status," +
            "b.type_id,c.type_name,b.company_original,b.department_original,b.duty_original,b.company,b.department,b.duty,b.take_office_time,b.take_office_time_end,b.take_office_status,b.change_url,b.duties_update_time,b.duties_update_reason,b.check_status,b.check_result,b.article_id,b.article_title,b.update_desc,b.original_id,b.new_id,b.merge_status,a.create_by,a.create_time,a.update_by,a.update_time " +
            "from character_basic_info a " +
            "INNER JOIN character_change_info b " +
            "on a.id = b.id " +
            "LEFT JOIN character_category_structure c " +
            "ON b.type_id = c.id " +
            "where a.id = #{id}")
    CharacterVo getById(String id);

    List<CharacterVo> getList(CharacterListVo characterListVo);

    Integer getCount(CharacterListVo characterListVo);

    List<CharacterVo> checkList(String articleId,String checkResult);

    @Select("select " +
            "a.id,a.uid,a.name,a.sex,a.birthplace,a.birthday,a.native_place,a.school,a.speciality,a.education,a.expert_occupation,a.head_sculpture,a.biographical_notes,a.category,a.award_records,a.part_time_job,a.research_field,a.evaluate,a.status," +
            "b.type_id,c.type_name,b.company_original,b.department_original,b.duty_original,b.company,b.department,b.duty,b.take_office_time,b.take_office_time_end,b.take_office_status,b.change_url,b.duties_update_time,b.duties_update_reason,b.check_status,b.check_result,b.article_id,b.article_title,b.update_desc,b.original_id,b.new_id,b.merge_status,a.create_by,a.create_time,a.update_by,a.update_time " +
            "from character_basic_info a " +
            "INNER JOIN character_change_info b " +
            "on a.id = b.id " +
            "LEFT JOIN character_category_structure c " +
            "ON b.type_id = c.id " +
            "where 1=1 " +
            "and (b.status != 0 or b.status IS NULL)" +
            "and b.check_result = 1 " +
            "and a.name = #{name} " +
            "and a.id != #{id} " +
            "and b.article_id != #{articleId}")
    List<CharacterVo> getListByName(String id, String name, String articleId);

    @Select("select count(1) " +
            "from character_basic_info a " +
            "INNER JOIN character_change_info b " +
            "on a.id = b.id " +
            "where 1=1 " +
            "and b.duty = #{duty} " +
            "and b.company = #{company} " +
            "and a.name = #{name}"
    )
    Integer deduplication(String duty, String company, String name);

    @Select("select " +
            "a.id,a.uid,a.name,a.sex,a.birthplace,a.birthday,a.native_place,a.school,a.speciality,a.education,a.expert_occupation,a.head_sculpture,a.biographical_notes,a.category,a.award_records,a.part_time_job,a.research_field,a.evaluate,a.status," +
            "b.type_id,c.type_name,b.company_original,b.department_original,b.duty_original,b.company,b.department,b.duty,b.take_office_time,b.take_office_time_end,b.take_office_status,b.change_url,b.duties_update_time,b.duties_update_reason,b.check_status,b.check_result,b.article_id,b.article_title,b.update_desc,b.original_id,b.new_id,b.merge_status,a.create_by,a.create_time,a.update_by,a.update_time, " +
            "COALESCE(b.take_office_time, b.create_time) AS order_time " +
            "from character_basic_info a " +
            "INNER JOIN character_change_info b " +
                "on a.id = b.id " +
            "LEFT JOIN character_category_structure c " +
                "ON b.type_id = c.id " +
            "where 1=1 " +
                "and b.status in (0,2) " +
                "and a.uid = #{uid} " +
            "order by order_time desc")
    List<CharacterVo> getPreviousDuty(String uid);

    @Select("select " +
            "id " +
            "from character_change_info " +
            "where 1=1 " +
            "and status = 2 " +
            "and uid = #{uid} ")
    List<String> getCorrelationByUid(String uid);
}
