package com.zzsn.leaderbase.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.entity.CharacterBasicInfoHistory;
import com.zzsn.leaderbase.entity.CharacterChangeInfo;
import com.zzsn.leaderbase.entity.CharacterChangeInfoHistory;
import com.zzsn.leaderbase.service.*;
import com.zzsn.leaderbase.vo.CharacterCheckVo;
import com.zzsn.leaderbase.vo.CharacterListVo;
import com.zzsn.leaderbase.vo.CharacterVo;
import com.zzsn.leaderbase.vo.Result;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 10:13
 * @Content: 人物基本信息和职务变更信息
 */
@Service
public class CharacterInfoServiceImpl implements CharacterInfoService {

    @Autowired
    CharacterBasicInfoService characterBasicInfoService;
    @Autowired
    CharacterBasicInfoHistoryService characterBasicInfoHistoryService;

    @Autowired
    CharacterChangeInfoService characterChangeInfoService;
    @Autowired
    CharacterChangeInfoHistoryService characterChangeInfoHistoryService;

    /**
     * 雪花算法生成id
     */
    @Autowired
    IGeneratorIdService generatorIdService;


    @Override
    public Result<?> add(CharacterVo characterVo) {

        characterVo.setUid(generatorIdService.getOrderId().toString());

        String id = Long.toString(generatorIdService.getOrderId());
        characterVo.setId(id);
        characterVo.setCreateTime(new Date());

        //vo对象获取转entity对象，基本信息
        CharacterBasicInfo characterBasicInfo = new CharacterBasicInfo();
        BeanUtils.copyProperties(characterVo, characterBasicInfo);
        characterBasicInfoService.save(characterBasicInfo);

        //vo对象获取转entity对象，任职变更信息
        CharacterChangeInfo characterChangeInfo = new CharacterChangeInfo();
        BeanUtils.copyProperties(characterVo, characterChangeInfo);
        characterChangeInfoService.save(characterChangeInfo);

        //记录任务基本信息修改记录
        CharacterBasicInfoHistory characterBasicInfoHistory = new CharacterBasicInfoHistory();
        BeanUtils.copyProperties(characterBasicInfo, characterBasicInfoHistory);
        characterBasicInfoHistory.setId(null);
        characterBasicInfoHistoryService.save(characterBasicInfoHistory);

        return Result.OK();
    }

    @Override
    public Result<?> addBulk(List<CharacterVo> list) {

        List<CharacterBasicInfo> characterBasicInfoList = new ArrayList<>();
        List<CharacterChangeInfo> characterChangeInfoList = new ArrayList<>();
        List<CharacterBasicInfoHistory> characterBasicInfoHistoryList = new ArrayList<>();
        for (CharacterVo characterVo : list) {
            String id = Long.toString(generatorIdService.getOrderId());
            characterVo.setId(id);
            characterVo.setCreateTime(new Date());

            CharacterBasicInfo characterBasicInfo = new CharacterBasicInfo();
            BeanUtils.copyProperties(characterVo, characterBasicInfo);
            characterBasicInfoList.add(characterBasicInfo);

            CharacterChangeInfo characterChangeInfo = new CharacterChangeInfo();
            BeanUtils.copyProperties(characterVo, characterChangeInfo);
            characterChangeInfoList.add(characterChangeInfo);

            CharacterBasicInfoHistory characterBasicInfoHistory = new CharacterBasicInfoHistory();
            BeanUtils.copyProperties(characterBasicInfo, characterBasicInfoHistory);
            characterBasicInfoHistory.setId(null);
            characterBasicInfoHistoryList.add(characterBasicInfoHistory);
        }

        characterBasicInfoService.saveBatch(characterBasicInfoList);
        characterChangeInfoService.saveBatch(characterChangeInfoList);
        characterBasicInfoHistoryService.saveBatch(characterBasicInfoHistoryList);

        return Result.OK();
    }

    @Override
    public CharacterVo getByUid(String uid) {
        return characterBasicInfoService.getByUid(uid);
    }

    @Override
    public CharacterVo getById(String id) {
        return characterBasicInfoService.getById(id);
    }

    @Override
    public Result<?> edit(CharacterVo characterVo) {

        characterVo.setUpdateTime(new Date());

        //vo对象获取转entity对象，基本信息
        CharacterBasicInfo characterBasicInfo = new CharacterBasicInfo();
        BeanUtils.copyProperties(characterVo, characterBasicInfo);
        characterBasicInfoService.updateById(characterBasicInfo);

        //vo对象获取转entity对象，任职变更信息
        CharacterChangeInfo characterChangeInfo = new CharacterChangeInfo();
        BeanUtils.copyProperties(characterVo, characterChangeInfo);
        characterChangeInfoService.updateById(characterChangeInfo);

        //记录人物基本信息修改记录
        CharacterBasicInfoHistory characterBasicInfoHistory = new CharacterBasicInfoHistory();
        BeanUtils.copyProperties(characterBasicInfo, characterBasicInfoHistory);
        characterBasicInfoHistory.setId(null);
        characterBasicInfoHistory.setCreateTime(new Date());
        characterBasicInfoHistoryService.save(characterBasicInfoHistory);

        return Result.OK();
    }

    @Override
    public Result<?> getList(CharacterListVo characterListVo) {
        IPage page = new Page();

        //根据条件查询数据
        List<CharacterVo> list = characterBasicInfoService.getList(characterListVo);

        page.setRecords(list);
        //查询总数
        Integer total = characterBasicInfoService.getCount(characterListVo);
        page.setTotal(total);
        Integer pageNo = characterListVo.getPageNo();
        Integer pageSize= characterListVo.getPageSize();
        page.setCurrent(pageNo);
        page.setSize(pageSize);

        return Result.OK(page);
    }

    @Override
    public Result<?> checkUpdate(CharacterCheckVo characterCheckVo) {

        CharacterVo originalCharacter = characterCheckVo.getOriginalCharacter();
        //先查询更新之前的任职信息保存到历史任职记录表中
        CharacterChangeInfo cci = characterChangeInfoService.getById(originalCharacter.getId());
        CharacterChangeInfoHistory characterChangeInfoHistory = new CharacterChangeInfoHistory();
        BeanUtils.copyProperties(cci, characterChangeInfoHistory);
        characterChangeInfoHistory.setId(null);
        characterChangeInfoHistory.setCreateTime(new Date());
        characterChangeInfoHistoryService.save(characterChangeInfoHistory);


        CharacterVo character = characterCheckVo.getCharacter();
        String characterId = character.getId();
        //更新人物
        character.setId(originalCharacter.getId());
        character.setUpdateTime(new Date());

        //vo对象获取转entity对象，基本信息
        CharacterBasicInfo characterBasicInfo = new CharacterBasicInfo();
        BeanUtils.copyProperties(character, characterBasicInfo);
        characterBasicInfoService.updateById(characterBasicInfo);

        //vo对象获取转entity对象，任职变更信息
        CharacterChangeInfo characterChangeInfo = new CharacterChangeInfo();
        BeanUtils.copyProperties(character, characterChangeInfo);
        characterChangeInfo.setUpdateDesc(characterId);
        characterChangeInfoService.updateById(characterChangeInfo);

        //记录人物基本信息修改记录
        CharacterBasicInfoHistory characterBasicInfoHistory = new CharacterBasicInfoHistory();
        BeanUtils.copyProperties(characterBasicInfo, characterBasicInfoHistory);
        characterBasicInfoHistory.setId(null);
        characterBasicInfoHistory.setCreateTime(new Date());
        characterBasicInfoHistoryService.save(characterBasicInfoHistory);

        //合并后的数据改为停用状态
        CharacterChangeInfo cciStatus = new CharacterChangeInfo();
        cciStatus.setId(characterId);
        cciStatus.setStatus(0L);
        characterChangeInfoService.updateById(cciStatus);

        return Result.OK();
    }

    @Override
    public Result<?> checkCancelUpdate(CharacterVo characterVo) {
        return null;
    }
}
