package com.zzsn.leaderbase.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
@TableName("cis_xgra_paper")
public class CisXgraPaper extends Model<CisXgraPaper> {


  //主键
  @TableId(value = "id", type = IdType.ASSIGN_ID)
  private String id;
  //'关联人物id'
  private String uid;
  //'人物名称'
  private String name;
  //'所属工作单位/学校'
  private String unit;
  //'职称'
  private String professionalTitle;
  //'研究方向'
  private String researchDirection;
  //'研究领域'
  private String researchArea;
  //'文献篇数'
  private Long documentCount;
  //'基金论文数'
  private Long foundsDocCount;
  //'核心期刊论文数'
  private Long coreDocCount;
  //'第一作者篇数'
  private Long firstAuthor;
  //'总被引频次'
  private Long allCitedCount;
  //'平均被引频次'
  private Long perCitedCount;
  //'总下载频次'
  private Long allDownloadCount;
  //'H指数'
  private Long hIndex;
  //'排序研究领域'
  private String sortArea;
  //'排序领域发文数量'
  private Long sortAreaDocCount;
  //'排序领域发文数是排名'
  private Long sortAreaDocNum;
  //'排序领域被引次数'
  private Long sortAreaCitedCount;
  //'排序领域被引次数排名'
  private Long sortAreaCitedNum;
  //'排序领域H指数'
  private Long sortAreaHIndex;
  //'排序领域H指数'
  private Long sortAreaHIndexNun;
  //'排冬排序领域G指数'
  private Long sortAreaGIndex;
  //'排序领域G指教排名'
  private Long sortAreaGIndexNum;
  //'个人简介'
  private String personalDes;
  //'履历'
  private String record;
  //'荣誉'
  private String honour;
  //'学者关注点'
  private String focusPoint;
  //'创建人'
  private String createBy;
  //'创建时间'
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  //'更新人'
  private String updateBy;
  //'更新时间'
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date updateTime;
  //'启停状态  1启 0停'
  private Long status;

}
