package com.zzsn.leaderbase.controller;

import com.zzsn.leaderbase.service.CharacterInfoService;
import com.zzsn.leaderbase.vo.CharacterCheckVo;
import com.zzsn.leaderbase.vo.CharacterListVo;
import com.zzsn.leaderbase.vo.CharacterVo;
import com.zzsn.leaderbase.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 9:26
 * @Content: 人物信息操作
 */
@RestController
@RequestMapping("/api/character")
public class CharacterInfoController {

    @Autowired
    CharacterInfoService characterInfoService;

    /**
     * 新增人物基本信息和职务变动
     * @param characterVo
     * @return
     */
    @PostMapping("/add")
    public Result<?> add(@RequestBody CharacterVo characterVo){
        return characterInfoService.add(characterVo);
    }

    /**
     * 根据人物uid查询人物信息
     * @param uid
     * @return
     */
    @GetMapping("getByUid")
    public Result<?> getByUid(@RequestParam(name="uid",required=true) String uid){
        return Result.OK(characterInfoService.getByUid(uid));
    }

    /**
     * 根据人物id主键查询
     * @param id
     * @return
     */
    @GetMapping
    public Result<?> getById(@RequestParam(name="id",required=true) String id){
        return Result.OK(characterInfoService.getById(id));
    }

    /**
     * 根据人物id修改信息
     * @param characterVo
     * @return
     */
    @PostMapping("/edit")
    public Result<?> edit(@RequestBody CharacterVo characterVo){
        return characterInfoService.edit(characterVo);
    }

    /**
     * 条件分页查询
     * @param characterListVo
     * @return
     */
    @PostMapping("/list")
    public Result<?> getList(@RequestBody CharacterListVo characterListVo){
        //参数校验
        Integer pageNo = characterListVo.getPageNo();
        Integer pageSize= characterListVo.getPageSize();
        if(pageNo < 1)
            return Result.error("参数pageNo的值不能小于1！");
        if(pageSize < 0)
            return Result.error("参数pageSize的值不能小于0！");
        Integer office = pageSize * (pageNo - 1);
        characterListVo.setOffset(office);
        return characterInfoService.getList(characterListVo);
    }

    //审核 更新人物
    @PostMapping("/checkUpdate")
    public Result<?> checkUpdate(@RequestBody CharacterCheckVo characterCheckVo){
        if(characterCheckVo.getOriginalCharacter() == null || characterCheckVo.getCharacter() == null)
            Result.error("参数有误：originalCharacter和character不能为空！");
        String originalCharacterId = characterCheckVo.getOriginalCharacter().getId();
        if(originalCharacterId == null || "".equals(originalCharacterId))
            Result.error("参数有误：原人物id不能为空");

        return characterInfoService.checkUpdate(characterCheckVo);

    }

    //审核 取消人物
    @PostMapping("/checkCancelUpdate")
    public Result<?> checkCancelUpdate(@RequestBody CharacterVo characterVo){

        return characterInfoService.checkCancelUpdate(characterVo);
    }



}
