package com.zzsn.leaderbase.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.entity.CharacterTagTop;
import com.zzsn.leaderbase.entity.LabelEntity;
import com.zzsn.leaderbase.entity.SysBaseLabelType;
import com.zzsn.leaderbase.mapper.CharacterTagMapper;
import com.zzsn.leaderbase.mapper.CharacterTagTopMapper;
import com.zzsn.leaderbase.service.CharacterBasicInfoService;
import com.zzsn.leaderbase.service.CharacterInfoService;
import com.zzsn.leaderbase.service.CharacterTagService;
import com.zzsn.leaderbase.vo.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/21 11:04
 * @Content:
 */
@Service
public class CharacterTagServiceImpl extends ServiceImpl<CharacterTagMapper, LabelEntity> implements CharacterTagService {

    @Autowired
    CharacterTagMapper characterTagMapper;

    @Autowired
    CharacterTagTopMapper characterTagTopMapper;

    @Autowired
    CharacterInfoService characterInfoService;

    @Autowired
    CharacterBasicInfoService characterBasicInfoService;

    @Value("${sys_base_label_type_id}")
    private String sys_base_label_type_id;


    @Override
    public Result<?> getTagList(String id, String name) {
        if(id == null || id.length() == 0){
            id = sys_base_label_type_id;
        }
        List<SysBaseLabelType> endNodes = getEndNodes(id);
        List<String> ids = new ArrayList<>();
        if (CollectionUtil.isEmpty(endNodes)){
            ids.add(id);
        }else {
            endNodes.forEach(e->ids.add(e.getId()));
        }

//        List<SysLabelVo> pageList = null;
//        pageList = baseMapper.queryCustomLabel(sysLabelVo, offset, pageSize);
        List<SysLabelVo> pageList = characterTagMapper.queryCustomLabel(ids,name);

        return Result.OK(pageList);
    }


    @Override
    public Result<?> getCharacterListByTag(String tagId, Integer pageNo, Integer pageSize) {
        BasicInfoListVo basicInfoListVo = new BasicInfoListVo();
        basicInfoListVo.setPageNo(pageNo);
        basicInfoListVo.setPageSize(pageSize);
        Integer office = pageSize * (pageNo - 1);
        basicInfoListVo.setOffset(office);
        basicInfoListVo.setTagId(tagId);
        IPage<CharacterBasicInfo> page = characterBasicInfoService.getList(basicInfoListVo);
        return Result.OK(page);

    }


    @Override
    public void addTagTop(CharacterTagTop characterTagTop){
        characterTagTopMapper.insert(characterTagTop);
    }

    @Override
    public Result<?> getTopTag() {
        List<CharacterTagTop> list = characterTagMapper.getTopTag();
        return Result.OK(list);
    }

    @Override
    public SysBaseLabelTypeVo getTagTypeList() {
//        List<SysBaseLabelTypeVo> allList = new ArrayList<>();
        //SysBaseLabelTypeVo sysBaseLabelTypeVo = new SysBaseLabelTypeVo();
        //sysBaseLabelTypeVo.setId("0");
//        sysBaseLabelTypeVo.setLabelName("所有");
//        sysBaseLabelTypeVo.setPid("0");
//        sysBaseLabelTypeVo.setHasChild("1");
        List<SysBaseLabelTypeVo> list = characterTagMapper.getTagTypeListAll();
        //只获取人物服务相关的类别
        List<SysBaseLabelTypeVo> treeList = getBaseLabelTreeList(list,sys_base_label_type_id,null);
//        sysBaseLabelTypeVo.setChildren(treeList);
//        allList.add(sysBaseLabelTypeVo);
//        return allList;
        if(treeList.size()==1)
            return treeList.get(0);
        return null;
    }

    @Override
    public void addTagTop(String tagId){

        CharacterTagTop characterTagTop = characterTagTopMapper.getByTagId(tagId);
        if (characterTagTop == null){
            LabelEntity labelEntity = this.getById(tagId);
            CharacterTagTop newTagTop = new CharacterTagTop();
            newTagTop.setTagId(tagId);
            newTagTop.setName(labelEntity.getName());
            newTagTop.setCountNum(1);
            characterTagTopMapper.insert(newTagTop);
        } else {
            characterTagTop.setCountNum(characterTagTop.getCountNum() + 1L);
            characterTagTopMapper.updateById(characterTagTop);
        }


    }


    /**
     * 根据标签类别id查询所有的末端节点
     * @param id
     * @return
     */
    public List<SysBaseLabelType> getEndNodes(String id){
        List<SysBaseLabelType> list = new ArrayList<>();

        //SysBaseLabelType byId = super.getById(id);
        SysBaseLabelType byId = characterTagMapper.getSysBaseLabelTypeById(id);
        if (ObjectUtil.isEmpty(byId)){
            return  list;
        }
        if ("0".equals(byId.getHasChild())){
            return list;
        }

        return getnodes(list,id);
    }

    /**
     * 递归查询
     * @param list
     * @param id
     * @return
     */
    private  List<SysBaseLabelType> getnodes(List<SysBaseLabelType> list,String id){

        //List<SysBaseLabelType> child = super.list(Wrappers.<SysBaseLabelType>lambdaQuery().eq(SysBaseLabelType::getPid, id));
        List<SysBaseLabelType> child = characterTagMapper.getgetSysBaseLabelTypeListByPid(id);
        child.forEach(e -> {
            if ("0".equals(e.getHasChild())){
                list.add(e);
            }else {
                getnodes(list,e.getId());
            }
        });
        return  list;
    }

    //获取树状结构
    private List<SysBaseLabelTypeVo> getBaseLabelTreeList(List<SysBaseLabelTypeVo> baseLabelTypeList, String id,Map<String,List<SysLabelVo>> dataMap){
        List<SysBaseLabelTypeVo> topList = new ArrayList<>();
        baseLabelTypeList.forEach(e->{
            if (id.equals(e.getId())) {
                if(dataMap!=null && dataMap.containsKey(e.getId())){
                    e.setDataList(dataMap.get(e.getId()));
                }
                topList.add(e);
            }
        });
        for (SysBaseLabelTypeVo sysLabelVo : topList) {
            setBaseLabelChildren(sysLabelVo, baseLabelTypeList,dataMap);
        }
        return topList;
    }
    //递归获取树形结构数据
    private void setBaseLabelChildren(SysBaseLabelTypeVo parent, List<SysBaseLabelTypeVo> list,Map<String,List<SysLabelVo>> dataMap) {
        Set<SysBaseLabelTypeVo> children = getBaseLabelChildren(list, parent.getId(),dataMap);
        parent.setChildren(new ArrayList<>(children));
        for (SysBaseLabelTypeVo sysLabelVo : children) {
            setBaseLabelChildren(sysLabelVo, list,dataMap);
        }
    }
    private Set<SysBaseLabelTypeVo> getBaseLabelChildren(List<SysBaseLabelTypeVo> list, String id,Map<String,List<SysLabelVo>> dataMap) {
        Set<SysBaseLabelTypeVo> children = new HashSet<>();
        for (SysBaseLabelTypeVo sysLabelVo : list) {
            if (sysLabelVo.getPid().equals(id)) {
                if(dataMap!=null&&dataMap.containsKey(sysLabelVo.getId())){
                    sysLabelVo.setDataList(dataMap.get(sysLabelVo.getId()));
                }
                children.add(sysLabelVo);
            }
        }
        return children;
    }

  @Override
  public Result<?> getTagAndDataTreeByRootId(String rootId){
      if(StringUtils.isEmpty(rootId)){
          rootId = sys_base_label_type_id;
      }
      List<SysBaseLabelTypeVo> list = characterTagMapper.getTagTypeListAll();
      List<SysBaseLabelTypeVo> originList =new ArrayList<>(list);
      List<String> typeIds=getAllIdsByRootId(list, rootId);
      List<SysLabelVo> dataList = characterTagMapper.queryCustomLabel(typeIds,null);
      Map<String,List<SysLabelVo>> dataMap=dataList.stream().collect(Collectors.groupingBy(SysLabelVo::getLabelTypeId));
      List<SysBaseLabelTypeVo> changeList =originList.stream().filter(t -> !list.contains(t)).collect(Collectors.toList());
      String finalRootId = rootId;
      SysBaseLabelTypeVo rootType=list.stream().filter(t->t.getId().equals(finalRootId)).findFirst().get();
      setBaseLabelChildren(rootType, changeList,dataMap);
      return Result.OK(rootType);
  }

    //获取指定根节点下所有子节点id集合
    public static List<String> getAllIdsByRootId(List<SysBaseLabelTypeVo> baseTypeList, String rootId) {
        if(StringUtils.isEmpty(rootId)||CollectionUtil.isEmpty(baseTypeList)){
            return Collections.emptyList();
        }
        List<String> idList = new ArrayList<>();
        Queue<String> queue = new LinkedList<>();
        queue.offer(rootId);

        while (!queue.isEmpty()) {
            String currentId = queue.poll();
            idList.add(currentId);
            Iterator<SysBaseLabelTypeVo> iterator = baseTypeList.iterator();
            while (iterator.hasNext()) {
                SysBaseLabelTypeVo node = iterator.next();
                if (currentId.equals(node.getPid())) {
                    queue.offer(node.getId());
                    iterator.remove();
                }
            }
        }
        return idList;
    }


}






