package com.zzsn.leaderbase.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.vo.BasicInfoListVo;
import com.zzsn.leaderbase.vo.CharacterListVo;
import com.zzsn.leaderbase.vo.CharacterVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 10:36
 * @Content:
 */
@Mapper
public interface CharacterBasicInfoMapper extends BaseMapper<CharacterBasicInfo> {

    @Select("select " +
            "a.id,a.uid,a.name,a.sex,a.birthplace,a.birthday,a.native_place,a.school,a.speciality,a.education,a.expert_occupation,a.head_sculpture,a.biographical_notes,a.category,a.award_records,a.part_time_job,a.research_field,a.evaluate,a.status," +
            "b.type_id,c.type_name,b.company_original,b.department_original,b.duty_original,b.company,b.department,b.duty,b.take_office_time,b.take_office_time_end,b.take_office_status,b.change_url,b.duties_update_time,b.duties_update_reason,b.check_status,b.check_result,b.article_id,b.article_index,b.update_desc,b.original_id,b.new_id,b.merge_status,a.create_by,a.create_time,a.update_by,a.update_time " +
            "from character_basic_info a " +
            "LEFT JOIN character_change_info b " +
            "on a.id = b.id " +
            "LEFT JOIN character_category_structure c " +
            "ON b.type_id = c.id " +
            "where a.uid = #{uid}")
    CharacterVo getByUid(String uid);

    @Select("select " +
            "a.id,a.uid,a.name,a.sex,a.birthplace,a.birthday,a.native_place,a.school,a.speciality,a.education,a.expert_occupation,a.head_sculpture,a.biographical_notes,a.category,a.award_records,a.part_time_job,a.research_field,a.evaluate,a.status," +
            "b.type_id,c.type_name,b.company_original,b.department_original,b.duty_original,b.company,b.department,b.duty,b.take_office_time,b.take_office_time_end,b.take_office_status,b.change_url,b.duties_update_time,b.duties_update_reason,b.check_status,b.check_result,b.article_id,b.article_index,b.update_desc,b.original_id,b.new_id,b.merge_status,a.create_by,a.create_time,a.update_by,a.update_time " +
            "from character_basic_info a " +
            "LEFT JOIN character_change_info b " +
            "on a.id = b.id " +
            "LEFT JOIN character_category_structure c " +
            "ON b.type_id = c.id " +
            "where a.id = #{id}")
    CharacterVo getById(String id);

    List<CharacterBasicInfo> getList(BasicInfoListVo basicInfoListVo);

    Integer getListCount(BasicInfoListVo basicInfoListVo);

    List<CharacterBasicInfo> getListHasChild(List<String> uidList);

    List<CharacterVo> checkList(String articleId,String checkResult);

    @Select("select * " +
           "from character_basic_info a " +
            "where 1=1 " +
            "and a.name = #{name} ")
    List<CharacterBasicInfo> getListByName(String name);

    @Select("select count(1) " +
            "from character_basic_info a " +
            "LEFT JOIN character_change_info b " +
            "on a.id = b.id " +
            "where 1=1 " +
            "and b.duty = #{duty} " +
            "and b.company = #{company} " +
            "and a.name = #{name}"
    )
    Integer deduplication(String duty, String company, String name);


    List<CharacterBasicInfo> getPreviousDuty(String uid,String id,String category);

    @Select("select " +
            "id " +
            "from character_change_info " +
            "where 1=1 " +
            "and status = 2 " +
            "and uid = #{uid} ")
    List<String> getCorrelationByUid(String uid);

    @Select("select " +
            "a.id,a.uid,a.name,a.sex,a.birthplace,a.birthday,a.native_place,a.school,a.speciality,a.education,a.expert_occupation,a.head_sculpture,a.biographical_notes,a.category,a.award_records,a.part_time_job,a.research_field,a.evaluate,a.status," +
            "b.type_id,b.company_original,b.department_original,b.duty_original,b.company,b.department,b.duty,b.take_office_time,b.take_office_time_end,b.take_office_status,b.change_url,b.duties_update_time,b.duties_update_reason,b.check_status,b.check_result,b.article_id,b.article_index,b.update_desc,b.original_id,b.new_id,b.merge_status,a.create_by,a.create_time,a.update_by,a.update_time " +
            "from character_basic_info a " +
            "LEFT JOIN character_change_info b " +
            "on a.id = b.id " +
            "where 1=1 " +
            "and (merge_status = 3 or merge_status = 4)" +
            "and b.original_id = #{id} " +
            "order by create_time desc ")
    List<CharacterVo> getByOriginalId(String id);

    @Select("select name from sys_base_enterprise " +
            "where 1=1 " +
            "and social_credit_code = #{socialCreditCode} " +
            "limit 1")
    String getDepartmentCreditCode(String socialCreditCode);

    @Select("select * from character_basic_info " +
            "where 1=1 " +
            "and category = 3 " +
            "and main_entry = 1 " +
            "and social_credit_code = #{socialCreditCode} ")
    List<CharacterBasicInfo> getBasicInfoByCreditCode(String socialCreditCode);

    @Select("<script> " +
            "select social_credit_code socialCreditCode,name department from sys_base_enterprise " +
            "where 1=1 " +
            "<if test='socialCreditCode != null and socialCreditCode != &apos;&apos;'> " +
            "  and social_credit_code = #{socialCreditCode} " +
            "</if>" +
            "<if test='department != null and department != &apos;&apos;'> " +
            "  and name like '%${department}%' " +
            "</if>" +
            "<if test='keyword != null and keyword != &apos;&apos;'> " +
            "  AND CONCAT_WS(',',social_credit_code,name) like '%${keyword}%' " +
            "</if>" +
            "limit 20 " +
            "</script>")
    List<Map<String, String>> getDepartment(String socialCreditCode, String department, String keyword);

    List<CharacterBasicInfo> getAllList(BasicInfoListVo basicInfoListVo);
}
