package com.zzsn.knowbase.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.zzsn.knowbase.entity.KbAuthorizedUser;
import com.zzsn.knowbase.entity.KnowFile;
import com.zzsn.knowbase.entity.Knowledge;
import com.zzsn.knowbase.vo.KnowledgeParam;
import com.zzsn.knowbase.vo.KnowledgeVO;
import com.zzsn.knowbase.vo.Result;

import javax.servlet.http.HttpServletRequest;

/**
 * @Description: 知识服务
 * @Author: chenshiqiang
 * @Version: V1.0
 */
public interface IKnowledgeService {


    /**
     * 新增
     */
    void addKnowledge(KnowFile knowFile, Knowledge knowledge, KbAuthorizedUser userInfo);

    /**
     * 修改
     */
    void updateKnowledge(Knowledge knowledge);

    /**
     * 删除
     */
    void deleteKnowledge(String ids);

    /**
     * 分页检索
     *
     * @param knowledgeParam
     * @param pageNo
     * @param pageSize
     * @param column
     * @param order
     * @return
     */
    IPage<KnowledgeVO> queryPageList(KnowledgeParam knowledgeParam, Integer pageNo, Integer pageSize, String column, String order);

    IPage<KnowledgeVO> listFromPython(KnowledgeParam knowledgeParam, Integer pageNo, Integer pageSize, String column, String order);

    KnowledgeVO getById(String id);

    Result<?> doImportInfo(HttpServletRequest request,String userId);

    void doExcel(HttpServletRequest request, String fileSuffix,String userId);
}
