package com.zzsn.knowbase.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description: 知识
 * @Author: chenshiqiang
 * @Version: V1.0
 */
@Data
@ApiModel(value = "group_type对象", description = "信息源组类别")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class Knowledge implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
     String id;
    /**
     * 标题
     */
    @Excel(name = "标题", width = 15)
    @ApiModelProperty(value = "标题")
    private String title;
    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createBy;
    /**
     * 创建日期
     */

    @ApiModelProperty(value = "创建日期")
    private String  createTime;
    /**
     * 更新人
     */
    @ApiModelProperty(value = "更新人")
    private String updateBy;
    /**
     * 更新日期
     */
    private String updateTime;
    /**
     * 状态（1启用 0不启用）
     */
    private Integer status;
    /**
     * 来源
     */
    private String origin;
    /**
     * 作者
     */
    private String author;
    /**
     * 发布时间
     */
    private String publishDate;
    /**
     * 审核时间
     */
    private String verifyTime;
    /**
     * 审核状态（0未审核1审核审核通过 2审核不通过）
     */
    private Integer verifyStatus;
    /**
     * 审核人id
     */
    private String verifierId;
    /**
     * 审核人名字
     */
    private String verifierName;
    /**
     * 知识库id
     */
    private String knowledgeProjectId;
    /**
     * 知识库id
     */
    private String kbKnowledgeId;
    private String content;
    /**
     * 类型
     */
    private String typeId;
    private String type;
    private Integer deleteFlag;
    private List<Content> contents;
    private List<KnowFile> files;
    private Integer score;
    private Integer importData;

}


