package com.zzsn.knowbase.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 *
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("kb_knowledges")
public class KbKnowledges extends Model<KbKnowledges> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 知识库分类名称
     */
    @TableField("name")
    private String name;
    /**
     * 绑定专题，多个用逗号分隔
     */
    @TableField("subject_id")
    private String subjectId;
    /**
     * 同步数据状态，多个用逗号分隔，为空同步所有状态
     */
    @TableField("subject_status")
    private String subjectStatus;
    /**
     * 同步数据发布状态，多个用逗号分隔，为空同步所有状态
     */
    @TableField("subject_publish_status")
    private String subjectPublishStatus;
    /**
     * 二级分类
     */
    @TableField("project_id")
    private String projectId;
    /**
     * 一级分类
     */
    @TableField("type_id")
    private String typeId;
    /**
     * 同步状态 1：启用 0：停用
     */
    @TableField("sync_status")
    private Integer syncStatus;
    /**
     * 排序序号
     */
    @TableField("sort")
    private Integer sort;
    /**
     * 数据同步开始时间
     */
    @TableField(exist = false)
    private String syncStart;
    /**
     * 数据同步结束时间
     */
    @TableField(exist = false)
    private String syncEnd;

}
