package com.zzsn.knowbase.service.impl;

import com.zzsn.knowbase.service.IKnowledgeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;

/**
 * Description: 异步处理service
 * Author: EDY
 * Date: 2023/7/26
 */
@Service
public class AsyncService {

    @Autowired
    @Lazy
    IKnowledgeService knowledgeService;

    //异步执行文件解析
    @Async
    public void doimport(HttpServletRequest request, MultipartFile multipartFile, String fileSuffix) {
        String subjectId = request.getParameter("subjectId");
        String isTopping = request.getParameter("isTopping");
        String isExamine = request.getParameter("isExamine");

        knowledgeService.doExcel(request, fileSuffix);
    }


}
