package com.zzsn.knowbase.controller;


import com.zzsn.knowbase.entity.KbKnowledges;
import com.zzsn.knowbase.service.KbKnowledgesService;
import com.zzsn.knowbase.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@RestController
@RequestMapping("/api/knowledges")
public class KbKnowledgesController {
    @Autowired
    KbKnowledgesService knowledgesService;

    /**
     * 根据id查询
     * */
    @GetMapping
    public Result<?> getById(@RequestParam(name="id",required=true) String id){
        return Result.OK(knowledgesService.getById(id));
    }

    @PostMapping("/add")
    public Result<?> add(@RequestBody KbKnowledges kbKnowledges){
       return Result.OK(knowledgesService.save(kbKnowledges));
    }
    /**
     * 编辑知识库
     * */
    @PostMapping("/edit")
    public Result<?> edit(@RequestBody KbKnowledges kbKnowledges){
       return Result.OK(knowledgesService.updateById(kbKnowledges));
    }

    /**
     * 删除知识库
     * */
    @GetMapping("/del")
    public Result<?> del(@RequestParam(name="id",required=true) String id){
       return Result.OK(knowledgesService.removeById(id));
    }

    @GetMapping("/list")
    public Result<?> list(){
        return  Result.OK(knowledgesService.list());
    }


}
