package com.zzsn.knowbase.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("kb_knowledge_project")
public class KbKnowledgeProject extends Model<KbKnowledgeProject> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 知识库分类名称
     */
    @TableField("type_name")
    private String typeName;

    /**
     * 父级id
     */
    @TableField("pid")
    private String pid;

    /**
     * 是否有子节点0，没有 1，有
     */
    @TableField("has_child")
    private String hasChild;

    /**
     * 分类
     */
    @TableField("category")
    private String category;

    /**
     * 状态0启用，1禁用
     */
    @TableField("status")
    private Integer status;

    /**
     * 节点绝对路径
     */
    @TableField("full_path")
    private String fullPath;

    /**
     * 创建人
     */
    @TableField("create_by")
    private String createBy;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private Date createTime;

    /**
     * 更新人
     */
    @TableField("update_by")
    private String updateBy;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private Date updateTime;

    /**
     * 机构编码
     */
    @TableField("sys_org_code")
    private String sysOrgCode;
    /**
     * 知识库分类描述
     */
    @TableField("project_description")
    private String projectDescription;



}
