package com.zzsn.knowbase.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.knowbase.entity.KbAuthorizedUser;
import com.zzsn.knowbase.vo.UserKnowPermissionVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@Mapper
public interface KbAuthorizedUserMapper extends BaseMapper<KbAuthorizedUser> {

    @Select("SELECT a.*,GROUP_CONCAT(b.role_id SEPARATOR ',') as roleId,GROUP_CONCAT(c.role_name SEPARATOR ',') as roleName FROM kb_authorized_user a " +
            "LEFT JOIN kb_user_role_map b ON a.id = b.user_id " +
            "LEFT JOIN kb_role c ON c.id = b.role_id " +
            "LEFT JOIN kb_authuser_knowledgeproject_map d ON d.auth_user_id = a.id " +
            "${ew.customSqlSegment}"+
            "GROUP BY a.id"
    )
    IPage<KbAuthorizedUser> pageList(Page<KbAuthorizedUser> page, @Param(Constants.WRAPPER) QueryWrapper<KbAuthorizedUser> query);

    @Select("SELECT a.*,GROUP_CONCAT(b.role_id SEPARATOR ',') as roleId,GROUP_CONCAT(c.role_name SEPARATOR ',') as roleName, b.knowledge_project_id FROM kb_authorized_user a " +
            "LEFT JOIN kb_user_role_map b ON a.id = b.user_id " +
            "LEFT JOIN kb_role c ON c.id = b.role_id " +
            "${ew.customSqlSegment}"+
            "GROUP BY a.id"
    )
    List<KbAuthorizedUser> listByUserIdAndProId(@Param(Constants.WRAPPER) QueryWrapper<KbAuthorizedUser> query);

    @Select("SELECT  a.user_id,a.knowledge_project_id,a.role_id,b.role_code,b.role_name,d.permission_code,d.permission_name FROM kb_user_role_map a " +
            "LEFT JOIN kb_role b ON a.role_id = b.id " +
            "LEFT JOIN kb_role_permission_map c ON b.id = c.role_id " +
            "LEFT JOIN kb_permissions d ON c.permission_id = d.id " +
            "WHERE a.user_id = #{userId}"
    )
    List<UserKnowPermissionVo> getUserPermission(String userId);


    @Select("SELECT a.*,GROUP_CONCAT(b.role_id SEPARATOR ',') as roleId,GROUP_CONCAT(c.role_name SEPARATOR ',') as roleName FROM kb_authorized_user a " +
            "LEFT JOIN kb_user_role_map b ON a.id = b.user_id " +
            "LEFT JOIN kb_role c ON c.id = b.role_id " +
            "${ew.customSqlSegment}"+
            "GROUP BY a.id"
    )
    KbAuthorizedUser getOne(@Param(Constants.WRAPPER) QueryWrapper<KbAuthorizedUser> query);


    @Select("SELECT  a.user_id,a.knowledge_project_id,a.role_id,b.role_code,b.role_name,d.permission_code,d.permission_name FROM kb_user_role_map a " +
            "LEFT JOIN kb_role b ON a.role_id = b.id " +
            "LEFT JOIN kb_role_permission_map c ON b.id = c.role_id " +
            "LEFT JOIN kb_permissions d ON c.permission_id = d.id " +
            "${ew.customSqlSegment}"
    )
    List<UserKnowPermissionVo> getUserPermissionByquery(@Param(Constants.WRAPPER) QueryWrapper<KbAuthorizedUser> query);
}
