package com.zzsn.knowbase.service.impl;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.knowbase.entity.KbKnowledgeProject;
import com.zzsn.knowbase.entity.KbKnowledgeProjectType;
import com.zzsn.knowbase.mapper.KbKnowledgeProjectTypeMapper;
import com.zzsn.knowbase.service.KbKnowledgeProjectTypeService;
import com.zzsn.knowbase.util.tree.Node;
import com.zzsn.knowbase.util.tree.TreeUtil;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@Service
public class KbKnowledgeProjectTypeServiceImpl extends ServiceImpl<KbKnowledgeProjectTypeMapper, KbKnowledgeProjectType> implements KbKnowledgeProjectTypeService {

    @Override
    public List<Node> getTreeList(List<KbKnowledgeProjectType> typelist, List<KbKnowledgeProject> list) {
        List<Node> nodes = new ArrayList<>();
        for (KbKnowledgeProjectType type : typelist) {
            Node node = new Node();
            node.setId(type.getId());
            node.setName(type.getName());
            node.setPid("0");
            nodes.add(node);
        }
        for (KbKnowledgeProject item : list) {
            Node node = new Node();
            node.setId(item.getId());
            node.setName(item.getTypeName());
            node.setPid("0".equals(item.getPid())?item.getCategory():item.getPid());
            nodes.add(node);
        }
        return TreeUtil.tree(nodes, "0");
    }
}
