package com.zzsn.knowbase.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.io.Serializable;
import java.util.List;

/**
 * @Description: 知识
 * @Author: chenshiqiang
 * @Version: V1.0
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class KnowledgeExcel  {

    @ExcelProperty(value = "数据id", index = 0)
    private String id;
    @ExcelProperty(value = "标题", index = 1)
    private String title;
    @ExcelProperty(value = "正文", index = 2)
    private String content;
    @ExcelProperty(value = "正文（带标签）", index = 3)
    private String contentWithTag;
    @ExcelProperty(value = "作者", index = 4)
    private String author;
    @ExcelProperty(value = "来源", index = 5)
    private String origin;
    @ExcelProperty(value = "发布时间", index = 6)
    private String publishDate;
    @ExcelProperty(value = "原文链接", index = 7)
    private String sourceAddress;
}


