package com.zzsn.knowbase.service.impl;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.knowbase.constant.Constants;
import com.zzsn.knowbase.entity.Content;
import com.zzsn.knowbase.entity.Knowledge;
import com.zzsn.knowbase.service.IKnowledgeService;
import com.zzsn.knowbase.util.CodeGenerateUtil;
import com.zzsn.knowbase.util.DateUtil;
import com.zzsn.knowbase.util.EsDateUtil;
import com.zzsn.knowbase.util.EsOpUtil;
import com.zzsn.knowbase.vo.KnowledgeParam;
import com.zzsn.knowbase.vo.KnowledgeVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Description: 知识
 * @Author: chenshiqiang
 * @Version: V1.0
 */
@Service
class KnowledgeServiceImpl implements IKnowledgeService {
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private EsOpUtil esOpUtil;
    @Autowired
    private CodeGenerateUtil codeGenerateUtil;

    @Override
    public void addKnowledge(Knowledge knowledge) {
        if (null == knowledge.getId()) {
            knowledge.setId(codeGenerateUtil.geneIdNo(Constants.FINANCE, 8));
        }
        if (null == knowledge.getVerifyStatus()) {
            knowledge.setVerifyStatus(0);
        }
        knowledge.setCreateTime(cn.hutool.core.date.DateUtil.formatDateTime(new Date()).replace(" ", "T"));
        knowledge.setDeleteFlag(0);
        List<Content> contents = new ArrayList<>();
        contents.add(Content.builder()
                .contentId(codeGenerateUtil.geneIdNo(Constants.FINANCE, 8))
                .content("content").build());
        knowledge.setContents(contents);
        esOpUtil.docSavaByEntity(Constants.ES_DATA_FOR_KNOWLEDGE, knowledge.getId(), knowledge);
    }

    @Override
    public void updateKnowledge(Knowledge knowledge) {
        esOpUtil.docSavaByEntity(Constants.ES_DATA_FOR_KNOWLEDGE, knowledge.getId(), knowledge);
    }

    @Override
    public void deleteKnowledge(String id) {
        esOpUtil.docDeleteById(Constants.ES_DATA_FOR_KNOWLEDGE, id);
    }

    @Override
    public IPage<KnowledgeVO> queryPageList(KnowledgeParam knowledgeParam, Integer pageNo, Integer pageSize, String column, String order) {


        SearchRequest searchRequest = new SearchRequest(Constants.ES_DATA_FOR_KNOWLEDGE);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        //设置分页参数
        searchSourceBuilder.size(pageSize);
        searchSourceBuilder.from((pageNo - 1) * pageSize);
        //默认按照置顶以及时间倒序排列
        //根据topNum正序查找，查询置顶数据
        searchSourceBuilder.sort("publishDate", SortOrder.DESC);
        if ("score".equals(column)) {
            if ("asc".equals(order)) {
                searchSourceBuilder.sort("score", SortOrder.ASC);
                searchSourceBuilder.sort("publishDate", SortOrder.ASC);
            } else if ("desc".equals(order)) {
                searchSourceBuilder.sort("score", SortOrder.DESC);
                searchSourceBuilder.sort("publishDate", SortOrder.DESC);
            }
        } else if ("publishDate".equals(column)) {
            if ("desc".equals(order)) {
                searchSourceBuilder.sort("publishDate", SortOrder.DESC);
                searchSourceBuilder.sort("score", SortOrder.DESC);
            } else if ("asc".equals(order)) {
                searchSourceBuilder.sort("publishDate", SortOrder.ASC);
                searchSourceBuilder.sort("score", SortOrder.ASC);
            }
        }
        //默认最大数量是10000，设置为true后，显示准确数量
        searchSourceBuilder.trackTotalHits(true);
        //创建查询对象
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();


        if (StringUtils.isNotEmpty(knowledgeParam.getTitle())) {
            boolQuery.must(QueryBuilders.matchPhraseQuery("title", knowledgeParam.getTitle()));
        }
        if (StringUtils.isNotEmpty(knowledgeParam.getOrigin())) {
            boolQuery.must(QueryBuilders.matchPhraseQuery("origin", knowledgeParam.getOrigin()));
        }

        if (StringUtils.isNotEmpty(knowledgeParam.getId())) {
            boolQuery.must(QueryBuilders.termQuery("id", knowledgeParam.getId()));
        }
        if (null != knowledgeParam.getVerifyStatus()) {
            boolQuery.must(QueryBuilders.termQuery("verifyStatus", knowledgeParam.getVerifyStatus()));

        }

        //时间过滤筛选
        if (StringUtils.isNotBlank(knowledgeParam.getStartTime())) {
            boolQuery.filter(QueryBuilders.rangeQuery("publishDate").gte(EsDateUtil.esFieldDateFormat(knowledgeParam.getStartTime())));
        }
        if (StringUtils.isNotBlank(knowledgeParam.getEndTime())) {
            boolQuery.filter(QueryBuilders.rangeQuery("publishDate").lte(EsDateUtil.esFieldDateFormat(knowledgeParam.getEndTime())));
        } else {
            boolQuery.filter(QueryBuilders.rangeQuery("publishDate").lte(EsDateUtil.esFieldDateFormat(DateUtil.dateToString(new Date()))));
        }

        if (StringUtils.isNotBlank(knowledgeParam.getContent())) {
            BoolQueryBuilder nestedBoolQueryBuilder = QueryBuilders.boolQuery();
            nestedBoolQueryBuilder.must(QueryBuilders.termQuery("contents.content", knowledgeParam.getContent()));
            NestedQueryBuilder nestedQueryBuilder = QueryBuilders.nestedQuery("contents", nestedBoolQueryBuilder, ScoreMode.None);
            boolQuery.must(nestedQueryBuilder);
        }
        searchSourceBuilder.query(boolQuery);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
        } catch (IOException e) {
            e.printStackTrace();
        }
        SearchHit[] searchHits = searchResponse.getHits().getHits();
        List<KnowledgeVO> list = new ArrayList<>();
        for (SearchHit hit : searchHits) {
            String queryInfo = hit.getSourceAsString();
            KnowledgeVO info = JSONUtil.toBean(queryInfo, KnowledgeVO.class);
            info.setPublishDate(EsDateUtil.esFieldDateMapping(info.getPublishDate()));
            list.add(info);
        }

        IPage<KnowledgeVO> pageData = new Page<>(pageNo, pageSize, searchResponse.getHits().getTotalHits().value);

        pageData.setRecords(list);
        return pageData;
    }

}
