package com.zzsn.knowbase.controller;

import com.zzsn.knowbase.entity.KbAuthorizedUser;
import com.zzsn.knowbase.entity.KnowFile;
import com.zzsn.knowbase.entity.Knowledge;
import com.zzsn.knowbase.service.ILocalFileService;
import com.zzsn.knowbase.util.SpringContextUtils;
import com.zzsn.knowbase.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/1/16 15:30
 * @Content:
 */
@RestController
@RequestMapping("/api/editKnowledge")
public class KbFileEditKnowledgeController {

    @Autowired
    private ILocalFileService localFileService;

    /**
     * 临时保存，保存并审核通过， 保存并审核不通过
     * @param request
     * @param knowledge
     * @return
     *
     * http://192.168.1.216:80/coauthoring/CommandService.ashx
     */
    @PostMapping("/editKnowledge")
    public Result<?> editKnowledge(@RequestBody  Knowledge knowledge) {
        Result result = localFileService.editKnowledge(knowledge);
        return result;
    }
}
