package com.zzsn.knowbase.util;

import org.springframework.web.multipart.MultipartFile;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FileMd5Utils {
	protected static char hexDigits[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e',
			'f' };
	protected static MessageDigest messageDigest = null;

	static {
		try {
			messageDigest = MessageDigest.getInstance("MD5");
		} catch (NoSuchAlgorithmException e) {
			System.err.println(FileMd5Utils.class.getName() + "初始化失败，MessageDigest不支持MD5Util.");
			e.printStackTrace();
		}
	}

	/**
	 * 计算文件的MD5
	 * 
	 * @param fileName
	 *            文件的绝对路径
	 * @return
	 * @throws IOException
	 */
	public static String getFileMD5String(String fileName) throws IOException {
		File f = new File(fileName);
		return getFileMD5String(f);
	}

	/**
	 * 计算文件的MD5，重载方法
	 * 
	 * @param file
	 *            文件对象
	 * @return
	 * @throws IOException
	 */
	public static String getFileMD5String(File file) throws IOException {
		FileInputStream in = null;
		FileChannel ch = null;
		MappedByteBuffer byteBuffer = null;
		try {
			in = new FileInputStream(file);
			ch = in.getChannel();
			byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0, file.length());
			messageDigest.update(byteBuffer);
		} catch (Exception e) {

		} finally {
			if (byteBuffer != null) {
				unmap(byteBuffer);
			}
			if (ch != null) {
				ch.close();
			}
			if (in != null) {
				in.close();
			}
		}
		return bufferToHex(messageDigest.digest());
	}

	public static String getFileMD5String(MultipartFile file) throws IOException {
		FileInputStream in = (FileInputStream) file.getInputStream();
		FileChannel ch = in.getChannel();
		MappedByteBuffer byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0, file.getSize());
		messageDigest.update(byteBuffer);
		return bufferToHex(messageDigest.digest());
	}

	/*
	 * 需要测试一下这个算法的长度是否正确。
	 */
	public static String getFileMD5String(FileInputStream in) throws IOException {
		FileChannel ch = in.getChannel();
		int len = in.read();
		MappedByteBuffer byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0, len);
		messageDigest.update(byteBuffer);
		return bufferToHex(messageDigest.digest());
	}

	public static String getFileMD5String(InputStream in) throws IOException {
		FileChannel ch = ((FileInputStream) in).getChannel();
		int len = in.read();
		MappedByteBuffer byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0, len);
		messageDigest.update(byteBuffer);
		return bufferToHex(messageDigest.digest());
	}

	public static String getMD5String(byte[] bytes) {
		messageDigest.update(bytes);
		return bufferToHex(messageDigest.digest());
	}

	public static String getMD5String(String s) {
		return getMD5String(s.getBytes());
	}

	private static String bufferToHex(byte bytes[]) {
		return bufferToHex(bytes, 0, bytes.length);
	}

	private static String bufferToHex(byte bytes[], int m, int n) {
		StringBuffer stringbuffer = new StringBuffer(2 * n);
		int k = m + n;
		for (int l = m; l < k; l++) {
			appendHexPair(bytes[l], stringbuffer);
		}
		return stringbuffer.toString();
	}

	private static void appendHexPair(byte bt, StringBuffer stringbuffer) {
		char c0 = hexDigits[(bt & 0xf0) >> 4];
		char c1 = hexDigits[bt & 0xf];
		stringbuffer.append(c0);
		stringbuffer.append(c1);
	}
	private static void unmap(MappedByteBuffer var0) {
		if(var0 != null){
			Cleaner var1 = ((DirectBuffer) var0).cleaner();
			if (var1 != null) {
				var1.clean();
			}
		}
	}
}
