/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzZ;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.ref.Ref;
import com.aspose.words.zzX;
import com.aspose.words.zzZFR;
import com.aspose.words.zzZGA;
import com.aspose.words.zzZPG;
import com.aspose.words.zzZPH;
import com.aspose.words.zzZPU;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzZPG,
Iterable<T> {
    private Node zzZST;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzsr() {
        CompositeNode compositeNode = this;
        return zzX.zzJ(compositeNode.getFirstChild()) != null;
    }

    final boolean zzsq() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzsp() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof zzZPU)) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        if (this.getLastChild() != null) {
            return this.getLastChild().zzZC3();
        }
        return null;
    }

    public Node getLastChild() {
        return this.zzZST;
    }

    final Node zzso() {
        return zzX.zzJ(this.getFirstChild());
    }

    final Node zzsn() {
        return zzX.zzI(this.getLastChild());
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzZ(boolean bl, zzZPH zzZPH2) {
        CompositeNode compositeNode = (CompositeNode)super.zzZ(bl, zzZPH2);
        ((CompositeNode)super.zzZ(bl, zzZPH2)).zzZST = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzh(node.zzZ(true, zzZPH2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzV(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzV(StringBuilder stringBuilder) {
        this.zzU(stringBuilder);
        zzZ.zzY(stringBuilder, this.zzsm());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            Node node2;
            int n = index + 1;
            boolean bl = zzX.zzTZ(nodeType);
            if (bl) {
                CompositeNode compositeNode = this;
                node2 = zzX.zzJ(compositeNode.getFirstChild());
            } else {
                node2 = node = this.getFirstChild();
            }
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzZC6() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzX.zzZ((Node)this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzX.zzY((Node)this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZGA(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzZ(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzZ(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzZ(oldChild, this, null, 1);
        if (documentBase.zz5T() && zzX.zzA(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzZ(nodeChangingArgs);
        }
        if (oldChild == this.getFirstChild()) {
            if (this.getLastChild().zzZC3() == this.getLastChild()) {
                this.zzZST = null;
            } else {
                Node node = oldChild.zzZC3();
                this.getLastChild().zzZh(node);
                node.zzZg(this.getLastChild());
            }
        } else {
            Node node = oldChild.zzZC2();
            Node node2 = oldChild.zzZC3();
            node.zzZh(node2);
            node2.zzZg(node);
            if (oldChild == this.getLastChild()) {
                this.zzZST = node;
            }
        }
        oldChild.zzZh(null);
        oldChild.zzZg(null);
        oldChild.zzZf(null);
        if (nodeChangingArgs != null) {
            documentBase.zzY(nodeChangingArgs);
        }
        return oldChild;
    }

    public void removeAllChildren() {
        zzZFR.zzA(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzh(Node node) {
        node.getParentNode();
        if (this.getLastChild() == null) {
            node.zzZg(node);
            node.zzZh(node);
        } else {
            Node node2 = this.getLastChild().zzZC3();
            node.zzZg(this.getLastChild());
            node.zzZh(node2);
            node2.zzZg(node);
            this.getLastChild().zzZh(node);
        }
        this.zzZST = node;
        node.zzZf(this);
        return node;
    }

    final void zzZ(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    final void zzY(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzg(Node node) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (zzX.zzY(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzsm().length();
    }

    String zzsm() {
        return "";
    }

    final String zzsl() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzU(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzU(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzV(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzZ(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzY(visitor));
    }

    abstract int zzZ(DocumentVisitor var1) throws Exception;

    abstract int zzY(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzl(Node var1);

    final Node zzZ(Node node, Node node2, boolean bl) {
        NodeChangingArgs nodeChangingArgs;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzZe(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 35 && !this.zzl(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        if (node.getParentNode() != null) {
            node.getParentNode().removeChild(node);
        }
        if ((nodeChangingArgs = documentBase.zzZ(node, null, this, 0)) != null) {
            documentBase.zzZ(nodeChangingArgs);
        }
        if (this.getLastChild() == null) {
            node.zzZg(node);
            node.zzZh(node);
            this.zzZST = node;
        } else if (bl) {
            if (node2 != null) {
                CompositeNode.zzV(node, node2);
                if (node2 == this.getLastChild()) {
                    this.zzZST = node;
                }
            } else {
                CompositeNode.zzV(node, this.getLastChild());
            }
        } else if (node2 != null) {
            Node node3 = node2.getPreviousSibling();
            if (node3 == null) {
                node3 = this.getLastChild();
            }
            CompositeNode.zzV(node, node3);
        } else {
            CompositeNode.zzV(node, this.getLastChild());
            this.zzZST = node;
        }
        node.zzZf(this);
        if (nodeChangingArgs != null) {
            documentBase.zzY(nodeChangingArgs);
        }
        if (documentBase.zz5T()) {
            zzX.zzB(node);
        }
        return node;
    }

    private static void zzV(Node node, Node node2) {
        Node node3 = node2.zzZC3();
        node.zzZg(node2);
        node.zzZh(node3);
        node2.zzZh(node);
        node3.zzZg(node);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Ref<Node> curNode) {
        Node node = curNode.get();
        curNode.set(curNode.get() == this ? this.getFirstChild() : curNode.get().getNextSibling());
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

