/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz2I;
import asposewobfuscated.zz37;
import asposewobfuscated.zz8X;
import asposewobfuscated.zzCM;
import asposewobfuscated.zzR1;
import asposewobfuscated.zzZ;
import com.aspose.words.BookmarkStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.DropDownItemCollection;
import com.aspose.words.Field;
import com.aspose.words.FieldChar;
import com.aspose.words.FieldOptions;
import com.aspose.words.FieldStart;
import com.aspose.words.Node;
import com.aspose.words.SpecialChar;
import com.aspose.words.zzYPT;
import com.aspose.words.zzZ0Z;
import com.aspose.words.zzZFR;
import com.aspose.words.zzZPH;
import com.aspose.words.zzZZW;

public class FormField
extends SpecialChar {
    private zzZZW zzZ72;
    private Field zzZ71;
    static String zzZ70 = zz37.zzV('\u2002', 5);
    private static final zz2I zzVW = new zz2I("uppercase", "lowercase", "first capital", "title case");

    FormField(DocumentBase doc, zzZZW formFieldPr, zzZ0Z runPr) {
        super(doc, '\u0001', runPr);
        this.zzZ72 = formFieldPr;
    }

    @Override
    final Node zzZ(boolean bl, zzZPH zzZPH2) {
        FormField formField = (FormField)super.zzZ(bl, zzZPH2);
        ((FormField)super.zzZ(bl, zzZPH2)).zzZ72 = (zzZZW)this.zzZ72.zzzf();
        formField.zzZ71 = null;
        return formField;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return FormField.visitorActionToBool(visitor.visitFormField(this));
    }

    public void removeField() throws Exception {
        if (this.getField() == null) {
            return;
        }
        BookmarkStart bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart != null) {
            bookmarkStart.remove();
            this.getField().getStart().zzZCa().insertBefore(bookmarkStart, this.getField().getStart());
        }
        this.getField().remove();
    }

    public void setTextInputValue(Object newValue) throws Exception {
        if (newValue == null) {
            throw new NullPointerException("newValue");
        }
        if (this.getType() != 70) {
            throw new IllegalStateException("The form field is not a text form field.");
        }
        switch (this.getTextInputType()) {
            case 0: {
                int n;
                String string = this.getTextInputFormat();
                string = string.toLowerCase();
                switch (zzVW.zzWP(string)) {
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 2: {
                        n = 4;
                        break;
                    }
                    case 3: {
                        n = 3;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                int n2 = n;
                this.setResult(zzCM.zzG((String)newValue, n2));
                return;
            }
            case 1: {
                double d;
                FieldOptions fieldOptions = this.zzZC9().getFieldOptions();
                Object object = newValue;
                if (object == null) {
                    d = 0.0;
                } else if (object instanceof Byte) {
                    d = ((Byte)object).byteValue();
                } else if (object instanceof Short) {
                    d = ((Short)object).shortValue();
                } else if (object instanceof Integer) {
                    d = ((Integer)object).intValue();
                } else if (object instanceof Long) {
                    d = ((Long)object).longValue();
                } else if (object instanceof Float) {
                    d = ((Float)object).floatValue();
                } else if (object instanceof Double) {
                    d = (Double)object;
                } else {
                    throw new ClassCastException("Cannot convert a value to double.");
                }
                this.setResult(zzR1.zzZ(d, this.getTextInputFormat(), true, fieldOptions.getLegacyNumberFormat(), fieldOptions.getUseInvariantCultureNumberFormat()));
                return;
            }
            case 2: {
                this.setResult(zzYPT.zzY((zz8X)newValue, this.getTextInputFormat()));
                return;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Cannot set the form field value because it is calculated.");
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    @Override
    public int getNodeType() {
        return 25;
    }

    public String getName() {
        return this.zzZ72.getName();
    }

    public void setName(String value) throws Exception {
        zzZ.zzZ((Object)value, "value");
        this.zzZ72.setName(value);
        BookmarkStart bookmarkStart = this.getBookmarkStart();
        if (bookmarkStart != null) {
            bookmarkStart.getBookmark().setName(this.zzZ72.getName());
        }
    }

    public int getType() {
        if (this.getField() != null) {
            return this.getField().getType();
        }
        return 0;
    }

    final int zzZTY() {
        switch (this.getType()) {
            case 70: {
                return 0;
            }
            case 71: {
                return 1;
            }
            case 83: {
                return 2;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    /*
     * Enabled aggressive block sorting
     */
    final Field getField() {
        if (this.zzZ71 == null) {
            FieldChar fieldChar;
            FieldChar fieldChar2;
            block7: {
                FormField formField = this;
                int n = 0;
                Node node = formField.getPreviousSibling();
                while (node != null) {
                    switch (node.getNodeType()) {
                        case 22: {
                            if (n-- != 0) break;
                            fieldChar2 = (FieldStart)node;
                            break block7;
                        }
                        case 24: {
                            ++n;
                        }
                    }
                    node = node.getPreviousSibling();
                }
                fieldChar2 = fieldChar = null;
            }
            if (fieldChar2 != null) {
                this.zzZ71 = fieldChar.getField();
            }
        }
        return this.zzZ71;
    }

    public String getResult() {
        switch (this.getType()) {
            case 70: {
                if (this.getField() == null) {
                    return "";
                }
                String string = this.getField().getResult();
                if (zz37.equals(string, zzZ70)) {
                    return "";
                }
                return string;
            }
            case 71: {
                if (this.getChecked()) {
                    return "1";
                }
                return "0";
            }
            case 83: {
                return this.zzZTX();
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public void setResult(String value) throws Exception {
        zzZ.zzZ((Object)value, "value");
        switch (this.getType()) {
            case 70: {
                this.getField().setResult(value);
                return;
            }
            case 71: {
                this.setChecked(zzR1.parseInt(value) != 0);
                return;
            }
            case 83: {
                this.zzQB(value);
                return;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public String getStatusText() {
        return this.zzZ72.getStatusText();
    }

    public void setStatusText(String value) {
        this.zzZ72.setStatusText(value);
    }

    public boolean getOwnStatus() {
        return this.zzZ72.zzZTT();
    }

    public void setOwnStatus(boolean value) {
        this.zzZ72.zzWG(value);
    }

    public String getHelpText() {
        return this.zzZ72.getHelpText();
    }

    public void setHelpText(String value) {
        this.zzZ72.setHelpText(value);
    }

    public boolean getOwnHelp() {
        return this.zzZ72.zzZTU();
    }

    public void setOwnHelp(boolean value) {
        this.zzZ72.zzWH(value);
    }

    public boolean getCalculateOnExit() {
        return this.zzZ72.zzZTV();
    }

    public void setCalculateOnExit(boolean value) {
        this.zzZ72.zzWI(value);
    }

    public String getEntryMacro() {
        return this.zzZ72.getEntryMacro();
    }

    public void setEntryMacro(String value) {
        this.zzZ72.setEntryMacro(value);
    }

    public String getExitMacro() {
        return this.zzZ72.getExitMacro();
    }

    public void setExitMacro(String value) {
        this.zzZ72.setExitMacro(value);
    }

    public boolean getEnabled() {
        return this.zzZ72.getEnabled();
    }

    public void setEnabled(boolean value) {
        this.zzZ72.setEnabled(value);
    }

    public String getTextInputFormat() {
        return this.zzZ72.getTextInputFormat();
    }

    public void setTextInputFormat(String value) {
        this.zzZ72.setTextInputFormat(value);
    }

    public int getTextInputType() {
        return this.zzZ72.getTextInputType();
    }

    public void setTextInputType(int value) {
        this.zzZ72.setTextInputType(value);
    }

    public String getTextInputDefault() {
        return this.zzZ72.getTextInputDefault();
    }

    public void setTextInputDefault(String value) throws Exception {
        this.zzZ72.setTextInputDefault(value);
        if (this.getTextInputType() == 5) {
            Node node = this.getField().getStart().zzFU(21);
            zzZFR.zzZ(node, false, this, false);
            DocumentBuilder documentBuilder = new DocumentBuilder(this.zzZC9());
            documentBuilder.moveTo(this);
            documentBuilder.insertField(value, "");
            this.getField().update();
        }
    }

    public int getMaxLength() {
        return this.zzZ72.zzZTS();
    }

    public void setMaxLength(int value) {
        this.zzZ72.zzKi(value);
    }

    public DropDownItemCollection getDropDownItems() {
        return this.zzZ72.getDropDownItems();
    }

    public int getDropDownSelectedIndex() {
        zzZZW zzZZW2 = this.zzZ72;
        if (zzZZW2.contains(21070)) {
            return this.zzZ72.zzZTM();
        }
        return this.zzZ72.zzZTN();
    }

    public void setDropDownSelectedIndex(int value) {
        this.zzZ72.zzKf(value);
    }

    final String zzZTX() {
        int n = this.getDropDownSelectedIndex();
        if (n < 0 || n >= this.getDropDownItems().getCount()) {
            return "";
        }
        return this.getDropDownItems().get(n);
    }

    final void zzQB(String string) {
        for (int i = 0; i < this.getDropDownItems().getCount(); ++i) {
            if (!zzCM.equalsIgnoreCase(this.getDropDownItems().get(i), string)) continue;
            this.setDropDownSelectedIndex(i);
            return;
        }
    }

    public boolean getChecked() {
        zzZZW zzZZW2 = this.zzZ72;
        if (zzZZW2.contains(21010)) {
            return this.zzZ72.zzZTO();
        }
        return this.zzZ72.zzZTP();
    }

    public void setChecked(boolean value) {
        this.zzZ72.zzWD(value);
    }

    public boolean getDefault() {
        return this.zzZ72.zzZTP();
    }

    public void setDefault(boolean value) {
        this.zzZ72.zzWE(value);
    }

    public boolean isCheckBoxExactSize() {
        return !this.zzZ72.zzZTR();
    }

    public void isCheckBoxExactSize(boolean value) {
        this.zzZ72.zzWF(!value);
    }

    public double getCheckBoxSize() {
        int n = this.zzZ72.zzZTQ();
        return (double)n / 2.0;
    }

    public void setCheckBoxSize(double value) {
        this.zzZ72.zzKh(zzZ.zzV(value));
    }

    final BookmarkStart getBookmarkStart() {
        if (this.getField() == null) {
            return null;
        }
        BookmarkStart bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart == null) {
            bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getPreviousSibling(), BookmarkStart.class);
        }
        return bookmarkStart;
    }

    final zzZZW zzZTW() {
        return this.zzZ72;
    }
}

