package com.zzsn.knowbase.controller;


import com.zzsn.knowbase.entity.KbKnowledgeProjectType;
import com.zzsn.knowbase.service.KbKnowledgeProjectTypeService;
import com.zzsn.knowbase.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@RestController
@RequestMapping("/api/projectType")
public class KbKnowledgeProjectTypeController {
    @Autowired
    KbKnowledgeProjectTypeService knowledgeProjectTypeService;

    /**
     * 根据id查询
     * */
    @GetMapping
    public Result<?> getById(@RequestParam(name="id",required=true) String id){
        return Result.OK(knowledgeProjectTypeService.getById(id));
    }

    @PostMapping("/add")
    public Result<?> add(@RequestBody KbKnowledgeProjectType bbKnowledgeProjectType){
       return Result.OK(knowledgeProjectTypeService.save(bbKnowledgeProjectType));
    }
    /**
     * 编辑知识库
     * */
    @PostMapping("/edit")
    public Result<?> edit(@RequestBody KbKnowledgeProjectType bbKnowledgeProjectType){
       return Result.OK(knowledgeProjectTypeService.updateById(bbKnowledgeProjectType));
    }

    /**
     * 删除知识库
     * */
    @GetMapping("/del")
    public Result<?> del(@RequestParam(name="id",required=true) String id){
       return Result.OK(knowledgeProjectTypeService.removeById(id));
    }

    @GetMapping("/list")
    public Result<?> list(){
        return  Result.OK(knowledgeProjectTypeService.list());

    }


}
