package com.zzsn.knowbase.kafka.producer;

import com.alibaba.fastjson.JSON;
import com.zzsn.knowbase.constant.Constants;
import com.zzsn.knowbase.kafka.cloudstream.KnowledgeChannel;
import com.zzsn.knowbase.kafka.message.KnowledgeMessage;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;


@Component
@Slf4j
@EnableBinding(KnowledgeChannel.class)
public class ProduceInfo {

    @Resource
    private KnowledgeChannel channel;

    /**
     * 发送知识内容列表
     *
     * @param knowledgeMessage 知识内容列表
     * @author chenshiqiang
     */
    public void sendKnowledgeContents(KnowledgeMessage knowledgeMessage) {
        if(Constants.SC_USER.equals(knowledgeMessage.getKbKnowledgeId())){
            //个人素材在推送到个人知识库
            knowledgeMessage.setKbKnowledgeId(knowledgeMessage.getUserId());
        }
        String msg = JSON.toJSONString(knowledgeMessage);
        Message<String> message = MessageBuilder.withPayload(msg).build();
        channel.knowledgeContents().send(message);
    }

    public void sendKnowledgeExcelContents(KnowledgeMessage knowledgeMessage) {
        String msg = JSON.toJSONString(knowledgeMessage);
        Message<String> message = MessageBuilder.withPayload(msg).build();
        channel.knowledgeExcels().send(message);
    }
}
