package com.zzsn.knowbase.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 知识参数
 *
 * @author ShiQiangChen
 * @date 2024/1/4
 */
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Data
public class KnowledgeParam {
    private String id;
    /**
     * 来源
     */
    private String origin;
    /**
     * 作者
     */
    private Integer author;
    /**
     * 发布时间
     */
    private String publishDate;
    /**
     * 审核状态
     */
    private Integer verifyStatus;
    /**
     * 审核人id
     */
    private String verifierId;
    /**
     * 审核人名字
     */
    private String verifierName;
    /**
     * 知识库id
     */
    private String knowledgeProjectId;
    /**
     * 类型
     */
    private String type;

    private String startTime;
    private String endTime;
    private String searchInfo;
    private Integer searchScope;
    private String searchAccuracy;

}
