package com.zzsn.knowbase.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.zzsn.knowbase.entity.KnowledgeExcel;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class ExcelExportUtil {

    /**
     * 读取excel数据
     *
     * @param firstRow  第一行有用数据(0表示第一行)
     * @param columnNum 有用数据的总列数
     * @return java.util.List<java.util.List < java.lang.String>>
     */
    public static List<List<String>> readExcel(InputStream inputStream, Integer firstRow, Integer columnNum) throws Exception {
        List<List<String>> dataList = new ArrayList<>();
        //获取整个excel
        XSSFWorkbook hb = new XSSFWorkbook(inputStream);
        int sheets = hb.getNumberOfSheets();
        for (int i = 0; i < sheets; i++) {
            XSSFSheet sheet = hb.getSheetAt(i);
            //第一行
            int firstRowNum = sheet.getFirstRowNum();
            //最后一行
            int lastRowNum = sheet.getPhysicalNumberOfRows();
            for (int j = firstRowNum + firstRow; j < lastRowNum; j++) {
                //获取行
                XSSFRow row = sheet.getRow(j);
                if (row != null) {
                    List<String> list = new ArrayList<>();
                    for (int m = 0; m < columnNum; m++) {
                        String data = ExcelExportUtil.getValue(row.getCell(m)).trim();
                        list.add(data);
                    }
                    dataList.add(list);
                }
            }
        }

        return dataList;
    }

    public static String getValue(XSSFCell xssfCell) {
        if (xssfCell == null || xssfCell.toString().trim().equals("")) {
            return "";
        }
        int cellType = xssfCell.getCellType();
        if (cellType == HSSFCell.CELL_TYPE_NUMERIC) {
            if (HSSFDateUtil.isCellDateFormatted(xssfCell)) {
                return TimeUtil.getDateString(xssfCell.getDateCellValue());
            } else {
                //防止数字变成科学计数法的形式
                DecimalFormat df = new DecimalFormat("0");
                return df.format(xssfCell.getNumericCellValue());
            }
        } else {
            return xssfCell.getStringCellValue();
        }
    }

    public static File getFileDir() {
        // 构建上传文件的存放 "文件夹" 路径
        String fileDirPath = new String("src/main/resources/static/uploadFiles" );
        File fileDir = new File(fileDirPath);
        if (!fileDir.exists()) {
            // 递归生成文件夹
            fileDir.mkdirs();
        }
        return fileDir;
    }


    /**
     * 导出
     * @param data
     * @param sheetName
     * @param filePath
     * @param clazz
     * @throws Exception
     */
    public static Boolean writeExcelFront(List data, String sheetName, String filePath, Class clazz) throws Exception {
        //表头样式
        System.out.println("开始写入");
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        //设置表头居中对齐
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        //内容样式
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        //设置内容靠左对齐
        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.LEFT);
        HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
        int total = data.size();//总数
        int max = 50000;//每sheet页允许最大数
        int avg = total / max;//sheet页个数
        ExcelWriter excelWriter= EasyExcel.write(filePath, clazz).excelType(ExcelTypeEnum.XLSX).registerWriteHandler(horizontalCellStyleStrategy).build();
        try{
            for (int j = 0; j < avg + 1; j++) {
                String sheetnames=sheetName;
                int num = j * max;
                List dataList1 = new ArrayList<>();
                if (StringUtils.isNotBlank(sheetnames)) {

                    sheetnames = sheetnames + (j + 1);
                } else {
                    sheetnames = j + "";
                }
                for (int n = num; n < total; n++) {//n即为每个sheet页应该开始的数
                    if(n>=num+50000){
                        break;
                    }

                    dataList1.add(data.get(n));//从总的list数据里面取出该处于哪个sheet页的数据，然后加进exportList，exportList即为当前sheet页应该有的数据

                }
                WriteSheet writeSheet = EasyExcel.writerSheet(j, sheetnames).build();
                excelWriter.write(dataList1,writeSheet);
            }
        }finally {
            // 千万别忘记finish 会帮忙关闭流
            if (excelWriter != null) {
                excelWriter.finish();
            }
        }
        System.out.println("写入完成");
        return true;
    }

    public static void download(HttpServletResponse response, String filePath, boolean delete) throws UnsupportedEncodingException {
        File file = new File(filePath);
        if (file.exists()) {
            response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(file.getName(), "utf8"));
            //加上设置大小 下载下来的excel文件才不会在打开前提示修复
            response.addHeader("Content-Length", String.valueOf(file.length()));
            byte[] buffer = new byte[1024];
            //输出流
            OutputStream os = null;
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            try {
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                os = response.getOutputStream();
                int i = bis.read(buffer);
                while (i != -1) {
                    os.write(buffer);
                    os.flush();
                    i = bis.read(buffer);
                }

            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                    if (bis != null) {
                        bis.close();
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (delete) {
                //文件下载结束后，删除上传到项目的文件
                file.delete();
            }
        }
    }

}
