package com.zzsn.knowbase.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 期刊论文/图书-拆分内容结构表
 *
 */
@Data
@TableName("ai_report_science_file_material")
public class AiReportScienceFileMaterial implements Serializable {

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;
    /**
     * 资料id
     */
    @TableField("file_id")
    private String fileId;
    /**
     * 资料内容
     */
    @TableField("content")
    private String content;
    /**
     * 内容类型（science：文章   chaper：章节   chaperContent：章节内容   paragraph：段落  paragraphContent：段落内容
     */
    @TableField("content_type")
    private String contentType;
    /**
     * 层级
     */
    @TableField("level")
    private String level;

    /**
     * 父级id
     */
    @TableField("parent")
    private String parent;

    /**
     * 排序
     */
    @TableField("sort")
    private Integer sort;

    /**
     * 创建人
     */
    @TableField("create_by")
    private String createBy;
    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("create_time")
    private Date createTime;
    /**
     * 更新人
     */
    @TableField("update_by")
    private String updateBy;
    /**
     * 更新时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("update_time")
    private Date updateTime;
    /**
     * 是否删除（0否    1是）
     */
    @TableField("deleted")
    private String deleted;
}
